/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.SingleEventIterable;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganizationType;
import com.espertech.esper.common.internal.epl.index.base.SingleReferenceEventTable;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceUngroupedBase;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class TableInstanceUngroupedImpl
extends TableInstanceUngroupedBase {
    private AtomicReference<ObjectArrayBackedEventBean> eventReference = new AtomicReference<Object>(null);

    public TableInstanceUngroupedImpl(Table table, AgentInstanceContext agentInstanceContext) {
        super(table, agentInstanceContext);
    }

    @Override
    public Collection<EventBean> getEventCollection() {
        EventBean event = this.eventReference.get();
        if (event == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(event);
    }

    @Override
    public long size() {
        return this.eventReference.get() == null ? 0L : 1L;
    }

    @Override
    public void addEvent(EventBean event) {
        if (event.getEventType() != this.table.getMetaData().getInternalEventType()) {
            throw new IllegalStateException("Unexpected event type for add: " + event.getEventType().getName());
        }
        if (this.eventReference.get() != null) {
            throw new EPException("Unique index violation, table '" + this.table.getMetaData().getTableName() + "' is a declared to hold a single un-keyed row");
        }
        this.agentInstanceContext.getInstrumentationProvider().qTableAddEvent(event);
        this.eventReference.set((ObjectArrayBackedEventBean)event);
        this.agentInstanceContext.getInstrumentationProvider().aTableAddEvent();
    }

    @Override
    public ObjectArrayBackedEventBean getCreateRowIntoTable(ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayBackedEventBean bean = this.eventReference.get();
        if (bean != null) {
            return bean;
        }
        return this.createRowIntoTable();
    }

    @Override
    public ObjectArrayBackedEventBean getEventUngrouped() {
        return this.eventReference.get();
    }

    @Override
    public void clearInstance() {
        this.clearEvents();
    }

    @Override
    public void destroy() {
        this.clearEvents();
    }

    private void clearEvents() {
        this.eventReference.set(null);
    }

    @Override
    public Iterable<EventBean> getIterableTableScan() {
        return new SingleEventIterable(this.eventReference);
    }

    @Override
    public void deleteEvent(EventBean matchingEvent) {
        this.agentInstanceContext.getInstrumentationProvider().qTableDeleteEvent(matchingEvent);
        this.eventReference.set(null);
        this.agentInstanceContext.getInstrumentationProvider().aTableDeleteEvent();
    }

    @Override
    public EventTable getIndex(String indexName, String indexModuleName) {
        if (indexName.equals(this.table.getName())) {
            EventTableOrganization org = new EventTableOrganization(this.table.getName(), true, false, 0, new String[0], EventTableOrganizationType.UNORGANIZED);
            return new SingleReferenceEventTable(org, this.eventReference);
        }
        throw new IllegalStateException("Invalid index requested '" + indexName + "'");
    }

    @Override
    public void handleRowUpdated(ObjectArrayBackedEventBean updatedEvent) {
        if (this.agentInstanceContext.getInstrumentationProvider().activated()) {
            this.agentInstanceContext.getInstrumentationProvider().qTableUpdatedEvent(updatedEvent);
            this.agentInstanceContext.getInstrumentationProvider().aTableUpdatedEvent();
        }
    }

    @Override
    public void handleRowUpdateKeyBeforeUpdate(ObjectArrayBackedEventBean updatedEvent) {
    }

    @Override
    public void handleRowUpdateKeyAfterUpdate(ObjectArrayBackedEventBean updatedEvent) {
    }
}

