/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;

public interface CompileTimeResolver {
    public static <T> T validateAmbiguous(T local, T path, T preconfigured, PathRegistryObjectType objectType, String name) {
        if (path != null && preconfigured != null) {
            throw new EPException("The " + objectType.getName() + " by name '" + name + "' is ambiguous as it exists in both the path space and the preconfigured space");
        }
        if (local != null) {
            if (path != null || preconfigured != null) {
                throw new EPException("The " + objectType.getName() + " by name '" + name + "' is ambiguous as it exists in both the local space and the path or preconfigured space");
            }
            return local;
        }
        return path != null ? path : preconfigured;
    }

    public static EPException makePathAmbiguous(PathRegistryObjectType objectType, String name, PathException e) {
        return new EPException("The " + objectType.getName() + " by name '" + name + "' is ambiguous as it exists for multiple modules: " + e.getMessage(), e);
    }
}

