/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.util;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.StateMgmtSetting;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.common.internal.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.common.internal.epl.util.ViewResourceVerifyResult;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateDesc;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateExpr;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactoryForge;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class ViewResourceVerifyHelper {
    public static ViewResourceVerifyResult verifyPreviousAndPriorRequirements(List<ViewFactoryForge>[] unmaterializedViewChain, ViewResourceDelegateExpr delegate, Integer subqueryNumber, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        int i;
        int numStreams = unmaterializedViewChain.length;
        ViewResourceDelegateDesc[] perStream = new ViewResourceDelegateDesc[numStreams];
        FabricCharge fabricCharge = services.getStateMgmtSettingsProvider().newCharge();
        boolean[] previousPerStream = new boolean[numStreams];
        for (ExprPreviousNode previousNode : delegate.getPreviousRequests()) {
            int stream = previousNode.getStreamNumber();
            List<ViewFactoryForge> forges = unmaterializedViewChain[stream];
            boolean pass = ViewResourceVerifyHelper.inspectViewFactoriesForPrevious(forges);
            if (!pass) {
                throw new ExprValidationException("Previous function requires a single data window view onto the stream");
            }
            boolean found = ViewResourceVerifyHelper.findDataWindow(forges);
            if (!found) {
                throw new ExprValidationException("Required data window not found for the 'prev' function, specify a data window for which previous events are retained");
            }
            previousPerStream[stream] = true;
        }
        StateMgmtSetting[] previousStateMgmtSettings = new StateMgmtSetting[numStreams];
        for (int streamNum = 0; streamNum < numStreams; ++streamNum) {
            if (!previousPerStream[streamNum]) continue;
            List<ViewFactoryForge> forges = unmaterializedViewChain[streamNum];
            EventType eventType = forges.get(forges.size() - 1).getEventType();
            previousStateMgmtSettings[streamNum] = services.getStateMgmtSettingsProvider().previous(fabricCharge, raw, streamNum, subqueryNumber, eventType);
        }
        SortedMap[] priorPerStream = new SortedMap[numStreams];
        for (ExprPriorNode priorNode : delegate.getPriorRequests()) {
            TreeMap treemap;
            LinkedList<ExprPriorNode> callbackList;
            int stream = priorNode.getStreamNumber();
            if (priorPerStream[stream] == null) {
                priorPerStream[stream] = new TreeMap();
            }
            if ((callbackList = (LinkedList<ExprPriorNode>)(treemap = (TreeMap)priorPerStream[stream]).get(priorNode.getConstantIndexNumber())) == null) {
                callbackList = new LinkedList<ExprPriorNode>();
                treemap.put(priorNode.getConstantIndexNumber(), callbackList);
            }
            callbackList.add(priorNode);
        }
        for (i = 0; i < numStreams; ++i) {
            if (priorPerStream[i] == null) continue;
            int relativeIndex = 0;
            for (Map.Entry entry : priorPerStream[i].entrySet()) {
                for (ExprPriorNode node : (List)entry.getValue()) {
                    node.setRelativeIndex(relativeIndex);
                }
                ++relativeIndex;
            }
        }
        for (i = 0; i < numStreams; ++i) {
            if (priorPerStream[i] == null) {
                priorPerStream[i] = new TreeMap();
            }
            perStream[i] = new ViewResourceDelegateDesc(previousPerStream[i], previousStateMgmtSettings[i], new TreeSet<Integer>(priorPerStream[i].keySet()));
        }
        return new ViewResourceVerifyResult(perStream, fabricCharge);
    }

    private static boolean findDataWindow(List<ViewFactoryForge> forges) {
        for (ViewFactoryForge forge : forges) {
            if (forge instanceof DataWindowViewForgeWithPrevious) {
                return true;
            }
            if (!(forge instanceof GroupByViewFactoryForge)) continue;
            GroupByViewFactoryForge group = (GroupByViewFactoryForge)forge;
            return ViewResourceVerifyHelper.findDataWindow(group.getGroupeds());
        }
        return false;
    }

    private static boolean inspectViewFactoriesForPrevious(List<ViewFactoryForge> viewFactories) {
        if (viewFactories.size() == 1) {
            return true;
        }
        if (viewFactories.size() == 2) {
            return viewFactories.get(0) instanceof GroupByViewFactoryForge;
        }
        return true;
    }
}

