/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.variable.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableManagementService;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerSetDesc;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWrite;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteArrayElement;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteCurly;
import com.espertech.esper.common.internal.epl.variable.core.VariableTriggerWriteDesc;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VariableReadWritePackage {
    public static final EPTypeClass EPTYPE = new EPTypeClass(VariableReadWritePackage.class);
    private Map<EventTypeSPI, EventBeanCopyMethod> copyMethods;
    private VariableTriggerSetDesc[] assignments;
    private VariableTriggerWrite[] writers;
    private Variable[] variables;
    private boolean[] mustCoerce;
    private VariableReader[] readersForGlobalVars;

    public void setCopyMethods(Map<EventTypeSPI, EventBeanCopyMethod> copyMethods) {
        this.copyMethods = copyMethods;
    }

    public void setAssignments(VariableTriggerSetDesc[] assignments) {
        this.assignments = assignments;
    }

    public void setWriters(VariableTriggerWrite[] writers) {
        this.writers = writers;
    }

    public void setVariables(Variable[] variables) {
        this.variables = variables;
    }

    public void setMustCoerce(boolean[] mustCoerce) {
        this.mustCoerce = mustCoerce;
    }

    public void setReadersForGlobalVars(VariableReader[] readersForGlobalVars) {
        this.readersForGlobalVars = readersForGlobalVars;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeVariables(EventBean[] eventsPerStream, Map<String, Object> valuesWritten, ExprEvaluatorContext exprEvaluatorContext) {
        HashSet<String> variablesBeansCopied = null;
        VariableManagementService variableService = exprEvaluatorContext.getVariableManagementService();
        if (!this.copyMethods.isEmpty()) {
            variablesBeansCopied = new HashSet<String>();
        }
        variableService.getReadWriteLock().writeLock().lock();
        try {
            variableService.setLocalVersion();
            int count = 0;
            for (VariableTriggerSetDesc assignment : this.assignments) {
                Object written;
                Variable variable = this.variables[count];
                VariableMetaData variableMetaData = variable.getMetaData();
                int agentInstanceId = variableMetaData.getOptionalContextName() == null ? -1 : exprEvaluatorContext.getAgentInstanceId();
                int variableNumber = variable.getVariableNumber();
                VariableTriggerWrite writeBase = this.writers[count];
                if (writeBase instanceof VariableTriggerWriteDesc) {
                    Object value;
                    writeDesc = (VariableTriggerWriteDesc)writeBase;
                    reader = variableService.getReader(this.variables[count].getDeploymentId(), variableMetaData.getVariableName(), agentInstanceId);
                    EventBean current = (EventBean)reader.getValue();
                    written = value = assignment.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    if (current != null) {
                        boolean copy = variablesBeansCopied.add(((VariableTriggerWriteDesc)writeDesc).getVariableName());
                        if (copy) {
                            current = this.copyMethods.get(((VariableTriggerWriteDesc)writeDesc).getType()).copy(current);
                        }
                        variableService.write(variableNumber, agentInstanceId, current);
                        ((VariableTriggerWriteDesc)writeDesc).getWriter().write(value, current);
                    }
                } else if (writeBase instanceof VariableTriggerWriteArrayElement) {
                    Object arrayValue;
                    writeDesc = (VariableTriggerWriteArrayElement)writeBase;
                    Integer index = (Integer)((VariableTriggerWriteArrayElement)writeDesc).getIndexExpression().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    VariableReader reader = variableService.getReader(this.variables[count].getDeploymentId(), variableMetaData.getVariableName(), agentInstanceId);
                    written = arrayValue = reader.getValue();
                    if (index != null && arrayValue != null) {
                        int len = Array.getLength(arrayValue);
                        if (index >= len) throw new EPException("Array length " + len + " less than index " + index + " for variable '" + ((VariableTriggerWriteArrayElement)writeDesc).getVariableName() + "'");
                        Object value = assignment.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
                        if (((VariableTriggerWriteArrayElement)writeDesc).getTypeWidener() != null) {
                            value = ((VariableTriggerWriteArrayElement)writeDesc).getTypeWidener().widen(value);
                        }
                        if (value != null || !arrayValue.getClass().getComponentType().isPrimitive()) {
                            Array.set(arrayValue, index, value);
                        }
                        variableService.write(variableNumber, agentInstanceId, arrayValue);
                    }
                } else if (writeBase instanceof VariableTriggerWriteCurly) {
                    writeDesc = (VariableTriggerWriteCurly)writeBase;
                    reader = variableService.getReader(this.variables[count].getDeploymentId(), variableMetaData.getVariableName(), agentInstanceId);
                    Object value = reader.getValue();
                    ((VariableTriggerWriteCurly)writeDesc).getExpression().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    variableService.write(variableNumber, agentInstanceId, value);
                    written = value;
                } else if (variableMetaData.getEventType() != null) {
                    EventType eventType = variableMetaData.getEventType();
                    Object value = assignment.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    EventBean eventBean = exprEvaluatorContext.getEventBeanTypedEventFactory().adapterForGivenType(value, variableMetaData.getEventType());
                    variableService.write(variableNumber, agentInstanceId, eventBean);
                    written = value;
                } else {
                    Object value = assignment.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
                    if (value != null && this.mustCoerce[count]) {
                        value = JavaClassHelper.coerceBoxed((Number)value, variableMetaData.getType().getType());
                    }
                    variableService.write(variableNumber, agentInstanceId, value);
                    written = value;
                }
                ++count;
                if (valuesWritten == null) continue;
                valuesWritten.put(assignment.getVariableName(), written);
            }
            variableService.commit();
            return;
        }
        catch (RuntimeException ex) {
            variableService.rollback();
            throw new EPException("Failed variable write: " + ex.getMessage(), ex);
        }
        finally {
            variableService.getReadWriteLock().writeLock().unlock();
        }
    }

    public Map<String, Object> iterate(VariableManagementService variableManagementService, int agentInstanceId) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        int count = 0;
        for (VariableTriggerSetDesc assignment : this.assignments) {
            Object value;
            if (this.readersForGlobalVars[count] == null) {
                VariableReader reader = variableManagementService.getReader(this.variables[count].getDeploymentId(), assignment.getVariableName(), agentInstanceId);
                if (reader == null) continue;
                value = reader.getValue();
            } else {
                value = this.readersForGlobalVars[count].getValue();
            }
            if (value == null) {
                values.put(assignment.getVariableName(), null);
            } else if (this.writers[count] instanceof VariableTriggerWriteDesc) {
                VariableTriggerWriteDesc desc = (VariableTriggerWriteDesc)this.writers[count];
                EventBean current = (EventBean)value;
                values.put(assignment.getVariableName(), desc.getGetter().get(current));
            } else if (value instanceof EventBean) {
                values.put(assignment.getVariableName(), ((EventBean)value).getUnderlying());
            } else {
                values.put(assignment.getVariableName(), value);
            }
            ++count;
        }
        return values;
    }
}

