/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;

public class ObjectArrayEntryPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final BeanEventType eventType;

    public ObjectArrayEntryPropertyGetter(int propertyIndex, BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        this.propertyIndex = propertyIndex;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.eventType = eventType;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return array[this.propertyIndex];
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object[] arr = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(arr);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.eventType == null) {
            return null;
        }
        Object result = this.get(eventBean);
        return BaseNestableEventUtil.getBNFragmentPojo(result, this.eventType, this.eventBeanTypedEventFactory);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.arrayAtIndex(underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpressionField svc = codegenClassScope.getPackageScope().addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField type = codegenClassScope.getPackageScope().addFieldUnshared(true, BeanEventType.EPTYPE, CodegenExpressionBuilder.cast(BeanEventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(this.eventType, EPStatementInitServices.REF)));
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentPojo", this.underlyingGetCodegen(underlyingExpression, codegenMethodScope, codegenClassScope), type, svc);
    }
}

