/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class ObjectArrayEventBeanCopyMethodWithArrayMap
implements EventBeanCopyMethod {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ObjectArrayEventBeanCopyMethodWithArrayMap.class);
    private final ObjectArrayEventType eventType;
    private final EventBeanTypedEventFactory eventAdapterService;
    private final int[] mapIndexesToCopy;
    private final int[] arrayIndexesToCopy;

    public ObjectArrayEventBeanCopyMethodWithArrayMap(ObjectArrayEventType eventType, EventBeanTypedEventFactory eventAdapterService, int[] mapIndexesToCopy, int[] arrayIndexesToCopy) {
        this.eventType = eventType;
        this.eventAdapterService = eventAdapterService;
        this.mapIndexesToCopy = mapIndexesToCopy;
        this.arrayIndexesToCopy = arrayIndexesToCopy;
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        ObjectArrayBackedEventBean arrayBacked = (ObjectArrayBackedEventBean)theEvent;
        Object[] props = arrayBacked.getProperties();
        Object[] shallowCopy = new Object[props.length];
        System.arraycopy(props, 0, shallowCopy, 0, props.length);
        for (int index : this.mapIndexesToCopy) {
            HashMap copy;
            Map innerMap = (Map)shallowCopy[index];
            if (innerMap == null) continue;
            shallowCopy[index] = copy = new HashMap(innerMap);
        }
        for (int index : this.arrayIndexesToCopy) {
            Object array = shallowCopy[index];
            if (array == null || !array.getClass().isArray() || Array.getLength(array) == 0) continue;
            Object copied = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
            System.arraycopy(array, 0, copied, 0, Array.getLength(array));
            shallowCopy[index] = copied;
        }
        return this.eventAdapterService.adapterForTypedObjectArray(shallowCopy, this.eventType);
    }
}

