/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.arr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;

public class ObjectArrayFragmentArrayPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final EventType fragmentEventType;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;

    public ObjectArrayFragmentArrayPropertyGetter(int propertyIndex, EventType fragmentEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        this.propertyIndex = propertyIndex;
        this.fragmentEventType = fragmentEventType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return array[this.propertyIndex];
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Object[] array = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(array);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        Object value = this.get(eventBean);
        if (value instanceof EventBean[]) {
            return value;
        }
        return BaseNestableEventUtil.getBNFragmentArray(value, this.fragmentEventType, this.eventBeanTypedEventFactory);
    }

    private CodegenMethod getFragmentCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenExpressionField mSvc = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField mType = codegenClassScope.addFieldUnshared(true, EventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(this.fragmentEventType, EPStatementInitServices.REF));
        return codegenMethodScope.makeChild(EPTypePremade.OBJECT.getEPType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "oa").getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "value", this.underlyingGetCodegen(CodegenExpressionBuilder.ref("oa"), codegenMethodScope, codegenClassScope)).ifInstanceOf("value", EventBean.EPTYPEARRAY).blockReturn(CodegenExpressionBuilder.ref("value")).methodReturn(CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentArray", CodegenExpressionBuilder.ref("value"), mType, mSvc));
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(EPTypePremade.OBJECTARRAY.getEPType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.arrayAtIndex(underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getFragmentCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }
}

