/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanEventPropertyWriter
implements EventPropertyWriterSPI {
    private static final Logger log = LoggerFactory.getLogger(BeanEventPropertyWriter.class);
    private final Class clazz;
    private final Method writerMethod;

    public BeanEventPropertyWriter(Class clazz, Method writerMethod) {
        this.clazz = clazz;
        this.writerMethod = writerMethod;
    }

    @Override
    public void write(Object value, EventBean target) {
        this.invoke(new Object[]{value}, target.getUnderlying());
    }

    public void writeValue(Object value, Object target) {
        this.invoke(new Object[]{value}, target);
    }

    @Override
    public CodegenExpression writeCodegen(CodegenExpression assigned, CodegenExpression und, CodegenExpression target, CodegenMethodScope parent, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.exprDotMethod(und, this.writerMethod.getName(), assigned);
    }

    protected void invoke(Object[] values, Object target) {
        try {
            this.writerMethod.invoke(target, values);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.handle(e);
        }
        catch (InvocationTargetException e) {
            this.handle(e.getTargetException());
        }
    }

    private void handle(Throwable e) {
        String message = "Unexpected exception encountered invoking setter-method '" + this.writerMethod + "' on class '" + this.clazz.getName() + "' : " + e.getMessage();
        log.error(message, e);
    }
}

