/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.getter.ReflectionPropMethodGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyType;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    private static final Logger log = LoggerFactory.getLogger(PropertyHelper.class);

    public static EventPropertyGetterSPI getGetter(Method method, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        return new ReflectionPropMethodGetter(method, eventBeanTypedEventFactory, beanEventTypeFactory);
    }

    public static List<PropertyStem> getProperties(Class clazz) {
        HashSet<Class> propertyOrigClasses = new HashSet<Class>();
        PropertyHelper.getImplementedInterfaceParents(clazz, propertyOrigClasses);
        propertyOrigClasses.add(clazz);
        return PropertyHelper.getPropertiesForClasses(propertyOrigClasses);
    }

    public static Set<WriteablePropertyDescriptor> getWritableProperties(Class clazz) {
        HashSet<Class> propertyOrigClasses = new HashSet<Class>();
        PropertyHelper.getImplementedInterfaceParents(clazz, propertyOrigClasses);
        propertyOrigClasses.add(clazz);
        return PropertyHelper.getWritablePropertiesForClasses(propertyOrigClasses);
    }

    private static void getImplementedInterfaceParents(Class clazz, Set<Class> classesResult) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            classesResult.add(interfaces[i]);
            PropertyHelper.getImplementedInterfaceParents(interfaces[i], classesResult);
        }
    }

    private static Set<WriteablePropertyDescriptor> getWritablePropertiesForClasses(Set<Class> propertyClasses) {
        HashSet<WriteablePropertyDescriptor> result = new HashSet<WriteablePropertyDescriptor>();
        for (Class clazz : propertyClasses) {
            PropertyHelper.addIntrospectPropertiesWritable(clazz, result);
        }
        return result;
    }

    private static List<PropertyStem> getPropertiesForClasses(Set<Class> propertyClasses) {
        LinkedList<PropertyStem> result = new LinkedList<PropertyStem>();
        for (Class clazz : propertyClasses) {
            PropertyHelper.addIntrospectProperties(clazz, result);
            PropertyHelper.addMappedProperties(clazz, result);
        }
        PropertyHelper.removeDuplicateProperties(result);
        PropertyHelper.removeJavaProperties(result);
        return result;
    }

    public static void removeJavaProperties(List<PropertyStem> properties) {
        LinkedList<PropertyStem> toRemove = new LinkedList<PropertyStem>();
        for (PropertyStem desc : properties) {
            if (!desc.getPropertyName().equals("class") && !desc.getPropertyName().equals("getClass") && !desc.getPropertyName().equals("toString") && !desc.getPropertyName().equals("hashCode")) continue;
            toRemove.add(desc);
        }
        for (PropertyStem desc : toRemove) {
            properties.remove(desc);
        }
    }

    protected static void removeDuplicateProperties(List<PropertyStem> properties) {
        LinkedHashMap<String, PropertyStem> set = new LinkedHashMap<String, PropertyStem>();
        LinkedList<PropertyStem> toRemove = new LinkedList<PropertyStem>();
        for (PropertyStem desc : properties) {
            if (set.containsKey(desc.getPropertyName())) {
                toRemove.add(desc);
                continue;
            }
            set.put(desc.getPropertyName(), desc);
        }
        for (PropertyStem desc : toRemove) {
            properties.remove(desc);
        }
    }

    protected static void addIntrospectProperties(Class clazz, List<PropertyStem> result) {
        PropertyDescriptor[] properties = PropertyHelper.introspect(clazz);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            String propertyName = property.getName();
            Method readMethod = property.getReadMethod();
            EventPropertyType type = EventPropertyType.SIMPLE;
            if (property instanceof IndexedPropertyDescriptor) {
                readMethod = ((IndexedPropertyDescriptor)property).getIndexedReadMethod();
                type = EventPropertyType.INDEXED;
            }
            if (readMethod == null) continue;
            result.add(new PropertyStem(propertyName, readMethod, type));
        }
    }

    private static void addIntrospectPropertiesWritable(Class clazz, Set<WriteablePropertyDescriptor> result) {
        PropertyDescriptor[] properties = PropertyHelper.introspect(clazz);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            String propertyName = property.getName();
            Method writeMethod = property.getWriteMethod();
            if (writeMethod == null) continue;
            Parameter parameter = writeMethod.getParameters()[0];
            EPTypeClass type = ClassHelperGenericType.getParameterType(parameter);
            result.add(new WriteablePropertyDescriptor(propertyName, type, writeMethod, false));
        }
    }

    protected static void addMappedProperties(Class clazz, List<PropertyStem> result) {
        HashSet<String> uniquePropertyNames = new HashSet<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            String inferredName;
            String methodName = methods[i].getName();
            if (!methodName.startsWith("get") || (inferredName = methodName.substring(3, methodName.length())).length() == 0 || (parameterTypes = methods[i].getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
            Object newInferredName = null;
            if (inferredName.length() >= 2 && Character.isUpperCase(inferredName.charAt(0)) && Character.isUpperCase(inferredName.charAt(1))) {
                newInferredName = inferredName;
            }
            if (newInferredName == null) {
                newInferredName = Character.toString(Character.toLowerCase(inferredName.charAt(0)));
                if (inferredName.length() > 1) {
                    newInferredName = (String)newInferredName + inferredName.substring(1, inferredName.length());
                }
            }
            if (uniquePropertyNames.contains(inferredName = newInferredName)) continue;
            result.add(new PropertyStem(inferredName, methods[i], EventPropertyType.MAPPED));
            uniquePropertyNames.add(inferredName);
        }
    }

    protected static PropertyDescriptor[] introspect(Class clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static String getGetterMethodName(String propertyName) {
        return PropertyHelper.getGetterSetterMethodName(propertyName, "get");
    }

    public static String getSetterMethodName(String propertyName) {
        return PropertyHelper.getGetterSetterMethodName(propertyName, "set");
    }

    public static String getIsMethodName(String propertyName) {
        return PropertyHelper.getGetterSetterMethodName(propertyName, "is");
    }

    private static String getGetterSetterMethodName(String propertyName, String operation) {
        StringWriter writer = new StringWriter();
        writer.write(operation);
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }
}

