/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.event.bean.core.DynamicPropertyDescriptorByMethod;
import com.espertech.esper.common.internal.event.bean.core.PropertyHelper;
import com.espertech.esper.common.internal.event.bean.getter.DynamicPropertyGetterByMethodBase;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DynamicIndexedPropertyGetterByMethod
extends DynamicPropertyGetterByMethodBase {
    private final String getterMethodName;
    private final Object[] parameters;
    private final int index;

    public DynamicIndexedPropertyGetterByMethod(String fieldName, int index, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory);
        this.getterMethodName = PropertyHelper.getGetterMethodName(fieldName);
        this.parameters = new Object[]{index};
        this.index = index;
    }

    @Override
    protected Method determineMethod(Class clazz) {
        return DynamicIndexedPropertyGetterByMethod.dynamicIndexPropertyDetermineMethod(clazz, this.getterMethodName);
    }

    @Override
    protected CodegenExpression determineMethodCodegen(CodegenExpressionRef clazz, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(DynamicIndexedPropertyGetterByMethod.class, "dynamicIndexPropertyDetermineMethod", clazz, CodegenExpressionBuilder.constant(this.getterMethodName));
    }

    @Override
    protected Object call(DynamicPropertyDescriptorByMethod descriptor, Object underlying) {
        return DynamicIndexedPropertyGetterByMethod.dynamicIndexedPropertyGet(descriptor, underlying, this.parameters, this.index);
    }

    @Override
    protected CodegenExpression callCodegen(CodegenExpressionRef desc, CodegenExpressionRef object, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField params = codegenClassScope.addFieldUnshared(true, EPTypePremade.OBJECTARRAY.getEPType(), CodegenExpressionBuilder.constant(this.parameters));
        return CodegenExpressionBuilder.staticMethod(DynamicIndexedPropertyGetterByMethod.class, "dynamicIndexedPropertyGet", desc, object, params, CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        DynamicPropertyDescriptorByMethod desc = DynamicIndexedPropertyGetterByMethod.getPopulateCache(this.cache, this, eventBean.getUnderlying(), this.eventBeanTypedEventFactory);
        if (desc.getMethod() == null) {
            return false;
        }
        return DynamicIndexedPropertyGetterByMethod.dynamicIndexedPropertyExists(desc, eventBean.getUnderlying(), this.index);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), DynamicPropertyGetterByMethodBase.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "object");
        method.getBlock().declareVar(DynamicPropertyDescriptorByMethod.EPTYPE, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.staticMethod(DynamicIndexedPropertyGetterByMethod.class, "dynamicIndexedPropertyExists", CodegenExpressionBuilder.ref("desc"), CodegenExpressionBuilder.ref("object"), CodegenExpressionBuilder.constant(this.index)));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    public static Method dynamicIndexPropertyDetermineMethod(Class clazz, String getterMethodName) {
        try {
            return clazz.getMethod(getterMethodName, Integer.TYPE);
        }
        catch (NoSuchMethodException ex1) {
            Method method;
            try {
                method = clazz.getMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (!method.getReturnType().isArray()) {
                return null;
            }
            return method;
        }
    }

    public static Object dynamicIndexedPropertyGet(DynamicPropertyDescriptorByMethod descriptor, Object underlying, Object[] parameters, int index) {
        try {
            if (descriptor.isHasParameters()) {
                return descriptor.getMethod().invoke(underlying, parameters);
            }
            Object array = descriptor.getMethod().invoke(underlying, null);
            if (array == null) {
                return null;
            }
            if (Array.getLength(array) <= index) {
                return null;
            }
            return Array.get(array, index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), e);
        }
    }

    public static boolean dynamicIndexedPropertyExists(DynamicPropertyDescriptorByMethod descriptor, Object underlying, int index) {
        try {
            if (descriptor.isHasParameters()) {
                return true;
            }
            Object array = descriptor.getMethod().invoke(underlying, null);
            if (array == null) {
                return false;
            }
            return Array.getLength(array) > index;
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, e);
        }
        catch (InvocationTargetException e) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), e);
        }
    }
}

