/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.event.bean.core.DynamicPropertyDescriptorByField;
import com.espertech.esper.common.internal.event.bean.getter.DynamicPropertyGetterByFieldBase;
import com.espertech.esper.common.internal.event.bean.getter.DynamicPropertyGetterByMethodBase;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Field;
import java.util.Map;

public class DynamicMappedPropertyGetterByField
extends DynamicPropertyGetterByFieldBase {
    private final String fieldName;
    private final String key;

    public DynamicMappedPropertyGetterByField(String fieldName, String key, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory);
        this.fieldName = fieldName;
        this.key = key;
    }

    @Override
    protected Field determineField(Class clazz) {
        return DynamicMappedPropertyGetterByField.dynamicMapperPropertyDetermineField(clazz, this.fieldName);
    }

    @Override
    protected CodegenExpression determineFieldCodegen(CodegenExpressionRef clazz, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetterByField.class, "dynamicMapperPropertyDetermineField", clazz, CodegenExpressionBuilder.constant(this.fieldName));
    }

    @Override
    protected Object call(DynamicPropertyDescriptorByField descriptor, Object underlying) {
        return DynamicMappedPropertyGetterByField.dynamicMappedPropertyGet(descriptor, underlying, this.key);
    }

    @Override
    protected CodegenExpression callCodegen(CodegenExpressionRef desc, CodegenExpressionRef object, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetterByField.class, "dynamicMappedPropertyGet", desc, object, CodegenExpressionBuilder.constant(this.key));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), DynamicPropertyGetterByMethodBase.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "object");
        method.getBlock().declareVar(DynamicPropertyDescriptorByField.EPTYPE, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getField", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.staticMethod(DynamicMappedPropertyGetterByField.class, "dynamicMappedPropertyExists", CodegenExpressionBuilder.ref("desc"), CodegenExpressionBuilder.ref("object"), CodegenExpressionBuilder.constant(this.key)));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        DynamicPropertyDescriptorByField desc = DynamicMappedPropertyGetterByField.getPopulateCache(this.cache, this, eventBean.getUnderlying(), this.eventBeanTypedEventFactory);
        if (desc.getField() == null) {
            return false;
        }
        return DynamicMappedPropertyGetterByField.dynamicMappedPropertyExists(desc, eventBean.getUnderlying(), this.key);
    }

    public static Field dynamicMapperPropertyDetermineField(Class clazz, String fieldName) throws PropertyAccessException {
        try {
            Field field = clazz.getField(fieldName);
            if (field.getType() != Map.class) {
                return null;
            }
            return field;
        }
        catch (NoSuchFieldException ex1) {
            return null;
        }
    }

    public static Object dynamicMappedPropertyGet(DynamicPropertyDescriptorByField descriptor, Object underlying, String key) {
        try {
            Object result = descriptor.getField().get(underlying);
            return CollectionUtil.getMapValueChecked(result, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getField(), underlying, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getField(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getField(), e);
        }
    }

    public static boolean dynamicMappedPropertyExists(DynamicPropertyDescriptorByField descriptor, Object underlying, String key) {
        try {
            Object result = descriptor.getField().get(underlying);
            return CollectionUtil.getMapKeyExistsChecked(result, key);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(descriptor.getField(), underlying, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getField(), e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getField(), e);
        }
    }
}

