/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.DynamicPropertyDescriptorByMethod;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class DynamicPropertyGetterByMethodBase
implements BeanEventPropertyGetter {
    protected final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    protected final BeanEventTypeFactory beanEventTypeFactory;
    protected final CopyOnWriteArrayList<DynamicPropertyDescriptorByMethod> cache;
    protected final CodegenFieldSharable sharableCode = new CodegenFieldSharable(){

        @Override
        public EPTypeClass type() {
            return EPTypePremade.COPYONWRITEARRAYLIST.getEPType();
        }

        @Override
        public CodegenExpression initCtorScoped() {
            return CodegenExpressionBuilder.newInstance(EPTypePremade.COPYONWRITEARRAYLIST.getEPType(), new CodegenExpression[0]);
        }
    };

    protected abstract Method determineMethod(Class var1);

    protected abstract CodegenExpression determineMethodCodegen(CodegenExpressionRef var1, CodegenMethodScope var2, CodegenClassScope var3);

    protected abstract Object call(DynamicPropertyDescriptorByMethod var1, Object var2);

    protected abstract CodegenExpression callCodegen(CodegenExpressionRef var1, CodegenExpressionRef var2, CodegenMethodScope var3, CodegenClassScope var4);

    public static Object cacheAndCall(CopyOnWriteArrayList<DynamicPropertyDescriptorByMethod> cache, DynamicPropertyGetterByMethodBase getter, Object object, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        DynamicPropertyDescriptorByMethod desc = DynamicPropertyGetterByMethodBase.getPopulateCache(cache, getter, object, eventBeanTypedEventFactory);
        if (desc.getMethod() == null) {
            return null;
        }
        return getter.call(desc, object);
    }

    private CodegenExpression cacheAndCallCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(EPTypePremade.OBJECT.getEPType(), DynamicPropertyGetterByMethodBase.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "object");
        method.getBlock().declareVar(DynamicPropertyDescriptorByMethod.EPTYPE, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(this.callCodegen(CodegenExpressionBuilder.ref("desc"), CodegenExpressionBuilder.ref("object"), method, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    public static boolean cacheAndExists(CopyOnWriteArrayList<DynamicPropertyDescriptorByMethod> cache, DynamicPropertyGetterByMethodBase getter, Object object, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        DynamicPropertyDescriptorByMethod desc = DynamicPropertyGetterByMethodBase.getPopulateCache(cache, getter, object, eventBeanTypedEventFactory);
        return desc.getMethod() != null;
    }

    protected CodegenExpression cacheAndExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField memberCache = codegenClassScope.addOrGetFieldSharable(this.sharableCode);
        CodegenMethod method = parent.makeChild(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), DynamicPropertyGetterByMethodBase.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "object");
        method.getBlock().declareVar(DynamicPropertyDescriptorByMethod.EPTYPE, "desc", this.getPopulateCacheCodegen(memberCache, CodegenExpressionBuilder.ref("object"), method, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("desc"), "getMethod", new CodegenExpression[0]))).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.constant(true));
        return CodegenExpressionBuilder.localMethod(method, underlyingExpression);
    }

    public DynamicPropertyGetterByMethodBase(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        this.beanEventTypeFactory = beanEventTypeFactory;
        this.cache = new CopyOnWriteArrayList();
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return DynamicPropertyGetterByMethodBase.cacheAndCall(this.cache, this, object, this.eventBeanTypedEventFactory, this.beanEventTypeFactory);
    }

    @Override
    public EPTypeClass getTargetType() {
        return EPTypePremade.OBJECT.getEPType();
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return DynamicPropertyGetterByMethodBase.cacheAndExists(this.cache, this, object, this.eventBeanTypedEventFactory);
    }

    @Override
    public final Object get(EventBean event) throws PropertyAccessException {
        return DynamicPropertyGetterByMethodBase.cacheAndCall(this.cache, this, event.getUnderlying(), this.eventBeanTypedEventFactory, this.beanEventTypeFactory);
    }

    @Override
    public EPTypeClass getBeanPropType() {
        return EPTypePremade.OBJECT.getEPType();
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.exprDotUnderlying(beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.exprDotUnderlying(beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.exprDotUnderlying(beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.cacheAndCallCodegen(underlyingExpression, codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        Object result = this.get(eventBean);
        return BaseNativePropertyGetter.getFragmentDynamic(result, this.eventBeanTypedEventFactory, this.beanEventTypeFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DynamicPropertyDescriptorByMethod getPopulateCache(CopyOnWriteArrayList<DynamicPropertyDescriptorByMethod> cache, DynamicPropertyGetterByMethodBase dynamicPropertyGetterBase, Object obj, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        DynamicPropertyDescriptorByMethod desc = DynamicPropertyGetterByMethodBase.dynamicPropertyCacheCheck(cache, obj);
        if (desc != null) {
            return desc;
        }
        DynamicPropertyGetterByMethodBase dynamicPropertyGetterByMethodBase = dynamicPropertyGetterBase;
        synchronized (dynamicPropertyGetterByMethodBase) {
            desc = DynamicPropertyGetterByMethodBase.dynamicPropertyCacheCheck(cache, obj);
            if (desc != null) {
                return desc;
            }
            Method method = dynamicPropertyGetterBase.determineMethod(obj.getClass());
            desc = DynamicPropertyGetterByMethodBase.dynamicPropertyCacheAdd(obj.getClass(), method, cache);
            return desc;
        }
    }

    protected CodegenExpression getPopulateCacheCodegen(CodegenExpression memberCache, CodegenExpressionRef object, CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenMethod method = parent.makeChild(DynamicPropertyDescriptorByMethod.EPTYPE, DynamicPropertyGetterByMethodBase.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.COPYONWRITEARRAYLIST.getEPType(), "cache").addParam(EPTypePremade.OBJECT.getEPType(), "obj");
        method.getBlock().declareVar(DynamicPropertyDescriptorByMethod.EPTYPE, "desc", CodegenExpressionBuilder.staticMethod(DynamicPropertyGetterByMethodBase.class, "dynamicPropertyCacheCheck", CodegenExpressionBuilder.ref("cache"), CodegenExpressionBuilder.ref("obj"))).ifRefNotNull("desc").blockReturn(CodegenExpressionBuilder.ref("desc")).declareVar(EPTypePremade.CLASS.getEPType(), "clazz", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("obj"), "getClass", new CodegenExpression[0])).declareVar(EPTypePremade.METHOD.getEPType(), "method", this.determineMethodCodegen(CodegenExpressionBuilder.ref("clazz"), method, codegenClassScope)).assignRef("desc", CodegenExpressionBuilder.staticMethod(DynamicPropertyGetterByMethodBase.class, "dynamicPropertyCacheAdd", CodegenExpressionBuilder.ref("clazz"), CodegenExpressionBuilder.ref("method"), CodegenExpressionBuilder.ref("cache"))).methodReturn(CodegenExpressionBuilder.ref("desc"));
        return CodegenExpressionBuilder.localMethod(method, memberCache, object);
    }

    public static DynamicPropertyDescriptorByMethod dynamicPropertyCacheCheck(CopyOnWriteArrayList<DynamicPropertyDescriptorByMethod> cache, Object obj) {
        Class<?> target = obj.getClass();
        for (DynamicPropertyDescriptorByMethod desc : cache) {
            if (desc.getClazz() != target) continue;
            return desc;
        }
        return null;
    }

    public static DynamicPropertyDescriptorByMethod dynamicPropertyCacheAdd(Class clazz, Method method, CopyOnWriteArrayList<DynamicPropertyDescriptorByMethod> cache) {
        DynamicPropertyDescriptorByMethod propertyDescriptor = method == null ? new DynamicPropertyDescriptorByMethod(clazz, null, false) : new DynamicPropertyDescriptorByMethod(clazz, method, method.getParameterTypes().length > 0);
        cache.add(propertyDescriptor);
        return propertyDescriptor;
    }

    public static PropertyAccessException handleException(DynamicPropertyDescriptorByMethod descriptor, Object underlying, Throwable t) {
        if (t instanceof ClassCastException) {
            throw PropertyUtility.getMismatchException(descriptor.getMethod(), underlying, (ClassCastException)t);
        }
        if (t instanceof InvocationTargetException) {
            throw PropertyUtility.getInvocationTargetException(descriptor.getMethod(), (InvocationTargetException)t);
        }
        if (t instanceof IllegalArgumentException) {
            throw PropertyUtility.getIllegalArgumentException(descriptor.getMethod(), (IllegalArgumentException)t);
        }
        if (t instanceof IllegalAccessException) {
            throw PropertyUtility.getIllegalAccessException(descriptor.getMethod(), (IllegalAccessException)t);
        }
        throw PropertyUtility.getGeneralException(descriptor.getMethod(), t);
    }
}

