/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndIndexed;
import com.espertech.esper.common.internal.event.util.PropertyUtility;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.util.List;

public class ListFieldPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final Field field;
    private final int index;

    public ListFieldPropertyGetter(Field field, int index, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, JavaClassHelper.getSingleParameterTypeOrObject(ClassHelperGenericType.getFieldEPType(field)));
        this.index = index;
        this.field = field;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.index);
    }

    private Object getBeanPropInternal(Object object, int index) throws PropertyAccessException {
        try {
            Object value = this.field.get(object);
            if (!(value instanceof List)) {
                return null;
            }
            List valueList = (List)value;
            if (valueList.size() <= index) {
                return null;
            }
            return valueList.get(index);
        }
        catch (ClassCastException e) {
            throw PropertyUtility.getMismatchException(this.field, object, e);
        }
        catch (IllegalAccessException e) {
            throw PropertyUtility.getIllegalAccessException(this.field, e);
        }
        catch (IllegalArgumentException e) {
            throw PropertyUtility.getIllegalArgumentException(this.field, e);
        }
    }

    private CodegenMethod getBeanPropInternalCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(this.getBeanPropType(), this.getClass(), (CodegenScope)codegenClassScope).addParam(this.getTargetType(), "object").addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "index").getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "value", (CodegenExpression)CodegenExpressionBuilder.exprDotName(CodegenExpressionBuilder.ref("object"), this.field.getName())).ifRefNotTypeReturnConst("value", EPTypePremade.LIST.getEPType(), null).declareVar(EPTypePremade.LIST.getEPType(), "l", CodegenExpressionBuilder.cast(EPTypePremade.LIST.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("value"))).ifConditionReturnConst(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("l"), "size", new CodegenExpression[0]), CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.ref("index")), null).methodReturn(CodegenExpressionBuilder.cast(this.getBeanPropType(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("l"), "get", CodegenExpressionBuilder.ref("index"))));
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ListFieldPropertyGetter  field=" + this.field.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public EPTypeClass getTargetType() {
        return ClassHelperGenericType.getClassEPType(this.field.getDeclaringClass());
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getBeanPropInternalCodegen(codegenMethodScope, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(this.getBeanPropInternalCodegen(codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), key);
    }
}

