/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.getter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.core.BeanEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;

public class NestedPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final BeanEventPropertyGetter[] getterChain;

    public NestedPropertyGetter(List<EventPropertyGetter> getterChain, EventBeanTypedEventFactory eventBeanTypedEventFactory, EPTypeClass type, BeanEventTypeFactory beanEventTypeFactory) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, type);
        this.getterChain = new BeanEventPropertyGetter[getterChain.size()];
        for (int i = 0; i < getterChain.size(); ++i) {
            this.getterChain[i] = (BeanEventPropertyGetter)getterChain.get(i);
        }
    }

    @Override
    public Object getBeanProp(Object value) throws PropertyAccessException {
        if (value == null) {
            return value;
        }
        for (int i = 0; i < this.getterChain.length; ++i) {
            if ((value = this.getterChain[i].getBeanProp(value)) != null) continue;
            return null;
        }
        return value;
    }

    @Override
    public boolean isBeanExistsProperty(Object value) {
        if (value == null) {
            return false;
        }
        int lastElementIndex = this.getterChain.length - 1;
        for (int i = 0; i < this.getterChain.length - 1; ++i) {
            if ((value = this.getterChain[i].getBeanProp(value)) != null) continue;
            return false;
        }
        return this.getterChain[lastElementIndex].isBeanExistsProperty(value);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        return this.getBeanProp(eventBean.getUnderlying());
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return this.isBeanExistsProperty(eventBean.getUnderlying());
    }

    @Override
    public EPTypeClass getTargetType() {
        return this.getterChain[0].getTargetType();
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(this.getTargetType(), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getBeanPropCodegen(codegenMethodScope, codegenClassScope, false), underlyingExpression);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getBeanPropCodegen(codegenMethodScope, codegenClassScope, true), underlyingExpression);
    }

    private CodegenMethod getBeanPropCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, boolean exists) {
        EPTypeClass typeClass = this.getterChain[this.getterChain.length - 1].getBeanPropType();
        EPTypeClass typeClassBoxed = JavaClassHelper.getBoxedType(typeClass);
        EPTypeClass targetType = this.getterChain[0].getTargetType();
        CodegenBlock block = codegenMethodScope.makeChild(exists ? EPTypePremade.BOOLEANPRIMITIVE.getEPType() : typeClassBoxed, this.getClass(), (CodegenScope)codegenClassScope).addParam(targetType, "value").getBlock();
        if (!exists) {
            block.ifRefNullReturnNull("value");
        } else {
            block.ifRefNullReturnFalse("value");
        }
        Object lastName = "value";
        for (int i = 0; i < this.getterChain.length - 1; ++i) {
            String varName = "l" + i;
            block.declareVar(this.getterChain[i].getBeanPropType(), varName, this.getterChain[i].underlyingGetCodegen(CodegenExpressionBuilder.ref((String)lastName), codegenMethodScope, codegenClassScope));
            lastName = varName;
            if (!exists) {
                block.ifRefNullReturnNull((String)lastName);
                continue;
            }
            block.ifRefNullReturnFalse((String)lastName);
        }
        if (!exists) {
            return block.methodReturn(this.getterChain[this.getterChain.length - 1].underlyingGetCodegen(CodegenExpressionBuilder.ref((String)lastName), codegenMethodScope, codegenClassScope));
        }
        return block.methodReturn(this.getterChain[this.getterChain.length - 1].underlyingExistsCodegen(CodegenExpressionBuilder.ref((String)lastName), codegenMethodScope, codegenClassScope));
    }
}

