/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.instantiator;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiator;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorByCtor;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorFactory;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorForge;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.OnDemandSunReflectionFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInstantiatorForgeByCtor
implements BeanInstantiatorForge {
    private static final Logger log = LoggerFactory.getLogger(BeanInstantiatorForgeByCtor.class);
    private final Class underlyingType;

    public BeanInstantiatorForgeByCtor(Class underlyingType) {
        this.underlyingType = underlyingType;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope codegenClassScope) {
        CodegenExpressionField ctor = codegenClassScope.addFieldUnshared(true, ClassHelperGenericType.getClassEPType(Constructor.class), CodegenExpressionBuilder.staticMethod(BeanInstantiatorForgeByCtor.class, "getSunJVMCtor", CodegenExpressionBuilder.constant(this.underlyingType)));
        return CodegenExpressionBuilder.staticMethod(BeanInstantiatorForgeByCtor.class, "instantiateSunJVMCtor", ctor);
    }

    public static Constructor getSunJVMCtor(Class underlyingType) {
        return OnDemandSunReflectionFactory.getConstructor(underlyingType, BeanInstantiatorFactory.SUN_JVM_OBJECT_CONSTRUCTOR);
    }

    public static Object instantiateSunJVMCtor(Constructor ctor) {
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            String message = "Unexpected exception encountered invoking constructor '" + ctor.getName() + "' on class '" + ctor.getDeclaringClass().getName() + "': " + e.getTargetException().getMessage();
            log.error(message, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            return BeanInstantiatorForgeByCtor.handle(ex, ctor);
        }
    }

    @Override
    public BeanInstantiator getBeanInstantiator() {
        return new BeanInstantiatorByCtor(BeanInstantiatorForgeByCtor.getSunJVMCtor(this.underlyingType));
    }

    private static Object handle(Exception e, Constructor ctor) {
        String message = "Unexpected exception encountered invoking newInstance on class '" + ctor.getDeclaringClass().getName() + "': " + e.getMessage();
        log.error(message, (Throwable)e);
        return null;
    }
}

