/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.introspect;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.util.PropertyResolutionStyle;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.getter.ReflectionPropFieldGetterFactory;
import com.espertech.esper.common.internal.event.bean.getter.ReflectionPropMethodGetterFactory;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.introspect.EventPropertyGetterSPIFactory;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyInfo;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilder;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilderFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyType;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BeanEventTypeStemBuilder {
    private final ConfigurationCommonEventTypeBean optionalConfig;
    private final PropertyResolutionStyle propertyResolutionStyle;
    private final boolean smartResolutionStyle;

    public BeanEventTypeStemBuilder(ConfigurationCommonEventTypeBean optionalConfig, PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.optionalConfig = optionalConfig;
        this.propertyResolutionStyle = optionalConfig != null ? optionalConfig.getPropertyResolutionStyle() : defaultPropertyResolutionStyle;
        this.smartResolutionStyle = this.propertyResolutionStyle.equals((Object)PropertyResolutionStyle.CASE_INSENSITIVE) || this.propertyResolutionStyle.equals((Object)PropertyResolutionStyle.DISTINCT_CASE_INSENSITIVE);
    }

    public BeanEventTypeStem make(EPTypeClass clazz) {
        EventTypeUtility.validateEventBeanClassVisibility(clazz.getType());
        PropertyListBuilder propertyListBuilder = PropertyListBuilderFactory.createBuilder(this.optionalConfig);
        List<PropertyStem> properties = propertyListBuilder.assessProperties(clazz.getType());
        EventPropertyDescriptor[] propertyDescriptors = new EventPropertyDescriptor[properties.size()];
        HashMap<String, EventPropertyDescriptor> propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        String[] propertyNames = new String[properties.size()];
        HashMap<String, PropertyInfo> simpleProperties = new HashMap<String, PropertyInfo>();
        HashMap<String, PropertyStem> mappedPropertyDescriptors = new HashMap<String, PropertyStem>();
        HashMap<String, PropertyStem> indexedPropertyDescriptors = new HashMap<String, PropertyStem>();
        HashMap<String, List<PropertyInfo>> simpleSmartPropertyTable = null;
        HashMap<String, List<PropertyInfo>> mappedSmartPropertyTable = null;
        HashMap<String, List<PropertyInfo>> indexedSmartPropertyTable = null;
        if (this.smartResolutionStyle) {
            simpleSmartPropertyTable = new HashMap<String, List<PropertyInfo>>();
            mappedSmartPropertyTable = new HashMap<String, List<PropertyInfo>>();
            indexedSmartPropertyTable = new HashMap<String, List<PropertyInfo>>();
        }
        int count = 0;
        for (PropertyStem desc : properties) {
            boolean isFragment;
            boolean isMapped;
            boolean isIndexed;
            boolean isRequiresMapkey;
            boolean isRequiresIndex;
            EPTypeClass underlyingType;
            String propertyName = desc.getPropertyName();
            if (desc.getPropertyType().equals((Object)EventPropertyType.SIMPLE)) {
                EPTypeClass type;
                EventPropertyGetterSPIFactory getter;
                if (desc.getReadMethod() != null) {
                    getter = new ReflectionPropMethodGetterFactory(desc.getReadMethod());
                    type = ClassHelperGenericType.getMethodReturnEPType(desc.getReadMethod(), clazz);
                } else {
                    if (desc.getAccessorField() == null) continue;
                    getter = new ReflectionPropFieldGetterFactory(desc.getAccessorField());
                    type = ClassHelperGenericType.getFieldEPType(desc.getAccessorField(), clazz);
                }
                underlyingType = type;
                isRequiresIndex = false;
                isRequiresMapkey = false;
                isIndexed = false;
                isMapped = false;
                if (JavaClassHelper.isImplementsInterface(type, Map.class)) {
                    isMapped = true;
                    isFragment = false;
                } else if (type.getType().isArray()) {
                    isIndexed = true;
                    isFragment = JavaClassHelper.isFragmentableType(type.getType().getComponentType());
                } else if (JavaClassHelper.isImplementsInterface(type, Iterable.class)) {
                    isIndexed = true;
                    Class genericType = type instanceof EPTypeClassParameterized ? ((EPTypeClassParameterized)type).getParameters()[0].getType() : Object.class;
                    isFragment = JavaClassHelper.isFragmentableType(genericType);
                } else {
                    isMapped = false;
                    isFragment = JavaClassHelper.isFragmentableType(type);
                }
                simpleProperties.put(propertyName, new PropertyInfo(type, getter, desc));
                if (this.smartResolutionStyle) {
                    String smartPropertyName = propertyName.toLowerCase(Locale.ENGLISH);
                    ArrayList<PropertyInfo> propertyInfoList = (ArrayList<PropertyInfo>)simpleSmartPropertyTable.get(smartPropertyName);
                    if (propertyInfoList == null) {
                        propertyInfoList = new ArrayList<PropertyInfo>();
                        simpleSmartPropertyTable.put(smartPropertyName, propertyInfoList);
                    }
                    PropertyInfo propertyInfo = new PropertyInfo(type, getter, desc);
                    propertyInfoList.add(propertyInfo);
                }
            } else if (desc.getPropertyType().equals((Object)EventPropertyType.MAPPED)) {
                mappedPropertyDescriptors.put(propertyName, desc);
                underlyingType = desc.getReturnType(clazz);
                isRequiresIndex = false;
                isRequiresMapkey = desc.getReadMethod().getParameterTypes().length > 0;
                isIndexed = false;
                isMapped = true;
                isFragment = false;
                if (this.smartResolutionStyle) {
                    smartPropertyName = propertyName.toLowerCase(Locale.ENGLISH);
                    propertyInfoList = (ArrayList)mappedSmartPropertyTable.get(smartPropertyName);
                    if (propertyInfoList == null) {
                        propertyInfoList = new ArrayList();
                        mappedSmartPropertyTable.put(smartPropertyName, propertyInfoList);
                    }
                    propertyInfo = new PropertyInfo(desc.getReturnType(clazz), null, desc);
                    propertyInfoList.add(propertyInfo);
                }
            } else {
                if (!desc.getPropertyType().equals((Object)EventPropertyType.INDEXED)) continue;
                indexedPropertyDescriptors.put(propertyName, desc);
                underlyingType = desc.getReturnType(clazz);
                isRequiresIndex = desc.getReadMethod().getParameterTypes().length > 0;
                isRequiresMapkey = false;
                isIndexed = true;
                isMapped = false;
                isFragment = JavaClassHelper.isFragmentableType(desc.getReturnType(clazz));
                if (this.smartResolutionStyle) {
                    smartPropertyName = propertyName.toLowerCase(Locale.ENGLISH);
                    propertyInfoList = (List)indexedSmartPropertyTable.get(smartPropertyName);
                    if (propertyInfoList == null) {
                        propertyInfoList = new ArrayList();
                        indexedSmartPropertyTable.put(smartPropertyName, propertyInfoList);
                    }
                    propertyInfo = new PropertyInfo(desc.getReturnType(clazz), null, desc);
                    propertyInfoList.add(propertyInfo);
                }
            }
            propertyNames[count] = desc.getPropertyName();
            EventPropertyDescriptor descriptor = new EventPropertyDescriptor(desc.getPropertyName(), underlyingType, isRequiresIndex, isRequiresMapkey, isIndexed, isMapped, isFragment);
            propertyDescriptors[count++] = descriptor;
            propertyDescriptorMap.put(descriptor.getPropertyName(), descriptor);
        }
        EPTypeClass[] superTypes = BeanEventTypeStemBuilder.getSuperTypes(clazz.getType());
        if (superTypes != null && superTypes.length == 0) {
            superTypes = null;
        }
        HashSet<EPTypeClass> deepSuperTypes = new HashSet<EPTypeClass>();
        BeanEventTypeStemBuilder.getSuper(clazz.getType(), deepSuperTypes);
        BeanEventTypeStemBuilder.removeJavaLibInterfaces(deepSuperTypes);
        return new BeanEventTypeStem(clazz, this.optionalConfig, propertyNames, simpleProperties, mappedPropertyDescriptors, indexedPropertyDescriptors, superTypes, deepSuperTypes, this.propertyResolutionStyle, simpleSmartPropertyTable, indexedSmartPropertyTable, mappedSmartPropertyTable, propertyDescriptors, propertyDescriptorMap);
    }

    private static EPTypeClass[] getSuperTypes(Class clazz) {
        Class<?>[] interfaces;
        LinkedList<EPTypeClass> superclasses = new LinkedList<EPTypeClass>();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            superclasses.add(ClassHelperGenericType.getClassEPType(superClass));
        }
        for (Class<?> interfaceItem : interfaces = clazz.getInterfaces()) {
            superclasses.add(ClassHelperGenericType.getClassEPType(interfaceItem));
        }
        LinkedList<EPTypeClass> superTypes = new LinkedList<EPTypeClass>();
        for (EPTypeClass superclass : superclasses) {
            String superclassName = superclass.getType().getName();
            if (superclassName.startsWith("java")) continue;
            superTypes.add(superclass);
        }
        return superTypes.toArray(new EPTypeClass[superTypes.size()]);
    }

    protected static void getSuper(Class clazz, Set<EPTypeClass> result) {
        BeanEventTypeStemBuilder.getSuperInterfaces(clazz, result);
        BeanEventTypeStemBuilder.getSuperClasses(clazz, result);
    }

    private static void getSuperInterfaces(Class clazz, Set<EPTypeClass> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result.add(ClassHelperGenericType.getClassEPType(interfaces[i]));
            BeanEventTypeStemBuilder.getSuperInterfaces(interfaces[i], result);
        }
    }

    private static void getSuperClasses(Class clazz, Set<EPTypeClass> result) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        result.add(ClassHelperGenericType.getClassEPType(superClass));
        BeanEventTypeStemBuilder.getSuper(superClass, result);
    }

    private static void removeJavaLibInterfaces(Set<EPTypeClass> classes) {
        EPTypeClass[] types;
        for (EPTypeClass clazz : types = classes.toArray(new EPTypeClass[0])) {
            if (!clazz.getType().getName().startsWith("java")) continue;
            classes.remove(clazz);
        }
    }
}

