/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.introspect;

import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.internal.event.bean.core.PropertyHelper;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilder;
import com.espertech.esper.common.internal.event.bean.introspect.PropertyListBuilderExplicit;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class PropertyListBuilderPublic
implements PropertyListBuilder {
    private ConfigurationCommonEventTypeBean legacyConfig;

    public PropertyListBuilderPublic(ConfigurationCommonEventTypeBean legacyConfig) {
        if (legacyConfig == null) {
            throw new IllegalArgumentException("Required configuration not passed");
        }
        this.legacyConfig = legacyConfig;
    }

    @Override
    public List<PropertyStem> assessProperties(Class clazz) {
        LinkedList<PropertyStem> result = new LinkedList<PropertyStem>();
        PropertyListBuilderExplicit.getExplicitProperties(result, clazz, this.legacyConfig);
        PropertyListBuilderPublic.addPublicFields(result, clazz);
        PropertyListBuilderPublic.addPublicMethods(result, clazz);
        return result;
    }

    private static void addPublicMethods(List<PropertyStem> result, Class clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> parameterType;
            if (JavaClassHelper.isTypeVoid(methods[i].getReturnType()) || methods[i].getParameterTypes().length >= 2 || methods[i].getParameterTypes().length == 1 && !JavaClassHelper.isTypeInteger(parameterType = methods[i].getParameterTypes()[0]) && parameterType != String.class) continue;
            PropertyStem desc = PropertyListBuilderExplicit.makeMethodDesc(methods[i], methods[i].getName());
            result.add(desc);
        }
        PropertyHelper.removeJavaProperties(result);
    }

    private static void addPublicFields(List<PropertyStem> result, Class clazz) {
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            PropertyStem desc = PropertyListBuilderExplicit.makeFieldDesc(fields[i], fields[i].getName());
            result.add(desc);
        }
    }
}

