/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.manufacturer;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiator;
import com.espertech.esper.common.internal.event.bean.instantiator.BeanInstantiatorFactory;
import com.espertech.esper.common.internal.event.core.EventBeanManufactureException;
import com.espertech.esper.common.internal.event.core.EventBeanManufacturer;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.WriteablePropertyDescriptor;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBeanManufacturerBean
implements EventBeanManufacturer {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EventBeanManufacturerBean.class);
    private static final Logger log = LoggerFactory.getLogger(EventBeanManufacturerBean.class);
    private final BeanInstantiator beanInstantiator;
    private final BeanEventType beanEventType;
    private final EventBeanTypedEventFactory service;
    private final Method[] writeMethodsReflection;
    private final boolean hasPrimitiveTypes;
    private final boolean[] primitiveType;

    public EventBeanManufacturerBean(BeanEventType beanEventType, EventBeanTypedEventFactory service, WriteablePropertyDescriptor[] properties, ClasspathImportService classpathImportService) throws EventBeanManufactureException {
        this.beanEventType = beanEventType;
        this.service = service;
        this.beanInstantiator = BeanInstantiatorFactory.makeInstantiator(beanEventType, classpathImportService).getBeanInstantiator();
        this.writeMethodsReflection = new Method[properties.length];
        boolean primitiveTypeCheck = false;
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.writeMethodsReflection[i] = properties[i].getWriteMethod();
            this.primitiveType[i] = JavaClassHelper.isTypePrimitive(properties[i].getType());
            primitiveTypeCheck |= this.primitiveType[i];
        }
        this.hasPrimitiveTypes = primitiveTypeCheck;
    }

    @Override
    public EventBean make(Object[] propertyValues) {
        Object outObject = this.makeUnderlying(propertyValues);
        return this.service.adapterForTypedBean(outObject, this.beanEventType);
    }

    @Override
    public Object makeUnderlying(Object[] propertyValues) {
        Object outObject = this.beanInstantiator.instantiate();
        if (!this.hasPrimitiveTypes) {
            Object[] parameters = new Object[1];
            for (int i = 0; i < this.writeMethodsReflection.length; ++i) {
                parameters[0] = propertyValues[i];
                try {
                    this.writeMethodsReflection[i].invoke(outObject, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    String message = "Unexpected exception encountered invoking setter-method '" + this.writeMethodsReflection[i] + "' on class '" + this.beanEventType.getUnderlyingType().getName() + "' : " + e.getTargetException().getMessage();
                    log.error(message, (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handle(e, this.writeMethodsReflection[i].getName());
                }
            }
        } else {
            Object[] parameters = new Object[1];
            for (int i = 0; i < this.writeMethodsReflection.length; ++i) {
                if (this.primitiveType[i] && propertyValues[i] == null) continue;
                parameters[0] = propertyValues[i];
                try {
                    this.writeMethodsReflection[i].invoke(outObject, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    this.handle(e, this.writeMethodsReflection[i].getName());
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handle(e, this.writeMethodsReflection[i].getName());
                }
            }
        }
        return outObject;
    }

    private void handle(InvocationTargetException ex, String methodName) {
        String message = "Unexpected exception encountered invoking setter-method '" + methodName + "' on class '" + this.beanEventType.getUnderlyingType().getName() + "' : " + ex.getTargetException().getMessage();
        log.error(message, (Throwable)ex);
    }

    private void handle(IllegalAccessException ex, String methodName) {
        String message = "Unexpected exception encountered invoking setter-method '" + methodName + "' on class '" + this.beanEventType.getUnderlyingType().getName() + "' : " + ex.getMessage();
        log.error(message, (Throwable)ex);
    }
}

