/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.bean.service;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.metric.RuntimeMetric;
import com.espertech.esper.common.client.metric.StatementMetric;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventTypeStemService;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactoryPrivate;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepository;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import com.espertech.esper.common.internal.util.CRC32Util;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventTypeRepositoryBeanTypeUtil {
    public static void buildBeanTypes(BeanEventTypeStemService beanEventTypeStemService, EventTypeRepositoryImpl repo, Map<String, EPTypeClass> beanTypes, BeanEventTypeFactoryPrivate privateFactory, Map<String, ConfigurationCommonEventTypeBean> configs) {
        if (beanTypes.isEmpty()) {
            beanTypes = new HashMap<String, EPTypeClass>();
        }
        EventTypeRepositoryBeanTypeUtil.addPredefinedBeanEventTypes(beanTypes);
        for (Map.Entry<String, EPTypeClass> beanType : beanTypes.entrySet()) {
            if (repo.getTypeByName(beanType.getKey()) != null) continue;
            EventTypeRepositoryBeanTypeUtil.buildPublicBeanType(beanEventTypeStemService, repo, beanType.getKey(), beanType.getValue(), privateFactory, configs);
        }
    }

    private static void buildPublicBeanType(BeanEventTypeStemService beanEventTypeStemService, EventTypeRepository repo, String eventTypeName, EPTypeClass clazz, BeanEventTypeFactoryPrivate privateFactory, Map<String, ConfigurationCommonEventTypeBean> configs) {
        EventType existingType = repo.getTypeByName(eventTypeName);
        if (existingType != null) {
            if (existingType.getMetadata().getApplicationType() != EventTypeApplicationType.CLASS) {
                throw new ConfigurationException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information: Class " + existingType.getUnderlyingType().getName() + " versus " + clazz.getTypeName());
            }
            BeanEventType beanEventType = (BeanEventType)existingType;
            if (beanEventType.getUnderlyingType() != clazz.getType()) {
                throw new ConfigurationException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information: Class " + existingType.getUnderlyingType().getName() + " versus " + beanEventType.getUnderlyingType());
            }
            return;
        }
        ConfigurationCommonEventTypeBean optionalConfig = configs.get(eventTypeName);
        BeanEventTypeStem stem = beanEventTypeStemService.getCreateStem(clazz, optionalConfig);
        long publicId = CRC32Util.computeCRC32(eventTypeName);
        EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, null, EventTypeTypeClass.STREAM, EventTypeApplicationType.CLASS, NameAccessModifier.PRECONFIGURED, EventTypeBusModifier.NONBUS, false, new EventTypeIdPair(publicId, -1L));
        EventType[] superTypes = EventTypeRepositoryBeanTypeUtil.getSuperTypes(stem.getSuperTypes(), beanEventTypeStemService, repo, privateFactory, configs);
        Set<EventType> deepSuperTypes = EventTypeRepositoryBeanTypeUtil.getDeepSupertypes(stem.getDeepSuperTypes(), beanEventTypeStemService, repo, privateFactory, configs);
        String startTS = optionalConfig == null ? null : optionalConfig.getStartTimestampPropertyName();
        String endTS = optionalConfig == null ? null : optionalConfig.getEndTimestampPropertyName();
        BeanEventType eventType = privateFactory.getEventTypeFactory().createBeanType(stem, metadata, privateFactory, superTypes, deepSuperTypes, startTS, endTS);
        repo.addType(eventType);
    }

    private static EventType[] getSuperTypes(EPTypeClass[] superTypes, BeanEventTypeStemService beanEventTypeStemService, EventTypeRepository repo, BeanEventTypeFactoryPrivate privateFactory, Map<String, ConfigurationCommonEventTypeBean> configs) {
        if (superTypes == null || superTypes.length == 0) {
            return null;
        }
        EventType[] types = new EventType[superTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = EventTypeRepositoryBeanTypeUtil.getBuildSuperType(superTypes[i], beanEventTypeStemService, repo, privateFactory, configs);
        }
        return types;
    }

    private static Set<EventType> getDeepSupertypes(Set<EPTypeClass> superTypes, BeanEventTypeStemService beanEventTypeStemService, EventTypeRepository repo, BeanEventTypeFactoryPrivate privateFactory, Map<String, ConfigurationCommonEventTypeBean> configs) {
        if (superTypes == null || superTypes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<EventType> supers = new LinkedHashSet<EventType>(4);
        for (EPTypeClass clazz : superTypes) {
            supers.add(EventTypeRepositoryBeanTypeUtil.getBuildSuperType(clazz, beanEventTypeStemService, repo, privateFactory, configs));
        }
        return supers;
    }

    public static EventType getBuildSuperType(EPTypeClass clazz, BeanEventTypeStemService beanEventTypeStemService, EventTypeRepository repo, BeanEventTypeFactoryPrivate privateFactory, Map<String, ConfigurationCommonEventTypeBean> configs) {
        EventType eventType;
        List<String> existingSuperTypeNames = beanEventTypeStemService.getPublicClassToTypeNames().get(clazz);
        if (existingSuperTypeNames != null && (eventType = repo.getTypeByName(existingSuperTypeNames.get(0))) != null) {
            return eventType;
        }
        EventTypeRepositoryBeanTypeUtil.buildPublicBeanType(beanEventTypeStemService, repo, clazz.getTypeName(), clazz, privateFactory, configs);
        return repo.getTypeByName(clazz.getTypeName());
    }

    private static void addPredefinedBeanEventTypes(Map<String, EPTypeClass> resolvedBeanEventTypes) {
        EventTypeRepositoryBeanTypeUtil.addPredefinedBeanEventType(StatementMetric.EPTYPE, resolvedBeanEventTypes);
        EventTypeRepositoryBeanTypeUtil.addPredefinedBeanEventType(RuntimeMetric.EPTYPE, resolvedBeanEventTypes);
    }

    private static void addPredefinedBeanEventType(EPTypeClass clazz, Map<String, EPTypeClass> resolvedBeanEventTypes) {
        EPTypeClass existing = resolvedBeanEventTypes.get(clazz.getType().getName());
        if (existing != null && !existing.equals(clazz)) {
            throw new ConfigurationException("Predefined event type " + clazz.getTypeName() + " expected class " + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + " but is already defined to another class " + existing);
        }
        resolvedBeanEventTypes.put(clazz.getType().getName(), clazz);
    }
}

