/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.event.core.DecoratingEventBean;
import com.espertech.esper.common.internal.event.core.EventBeanSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import java.util.Collections;
import java.util.Map;

public class WrapperEventBean
implements EventBeanSPI,
DecoratingEventBean {
    private EventBean theEvent;
    private Map<String, Object> map;
    private final EventType eventType;

    public WrapperEventBean(EventBean theEvent, Map<String, Object> properties, EventType eventType) {
        this.theEvent = theEvent;
        this.map = properties;
        this.eventType = eventType;
    }

    @Override
    public Object get(String property) throws PropertyAccessException {
        EventPropertyGetter getter = this.eventType.getGetter(property);
        if (getter == null) {
            throw new PropertyAccessException("Property named '" + property + "' is not a valid property name for this type");
        }
        return this.eventType.getGetter(property).get(this);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object getUnderlying() {
        if (this.map.isEmpty()) {
            return this.theEvent.getUnderlying();
        }
        return new Pair<Object, Map<String, Object>>(this.theEvent.getUnderlying(), this.map);
    }

    public Map getUnderlyingMap() {
        return this.map;
    }

    @Override
    public Map<String, Object> getDecoratingProperties() {
        return this.map;
    }

    @Override
    public EventBean getUnderlyingEvent() {
        return this.theEvent;
    }

    public String toString() {
        return "WrapperEventBean [event=" + this.theEvent + "] [properties=" + this.map + "]";
    }

    @Override
    public Object getFragment(String propertyExpression) {
        EventPropertyGetter getter = this.eventType.getGetter(propertyExpression);
        if (getter == null) {
            throw PropertyAccessException.notAValidProperty(propertyExpression);
        }
        return getter.getFragment(this);
    }

    @Override
    public void setUnderlying(Object underlying) {
        WrapperEventType type = (WrapperEventType)this.eventType;
        this.theEvent = EventTypeUtility.getShellForType(type.getUnderlyingEventType());
        if (underlying instanceof Pair) {
            Pair pair = (Pair)underlying;
            ((EventBeanSPI)this.theEvent).setUnderlying(pair.getFirst());
            this.map = (Map)pair.getSecond();
        } else {
            ((EventBeanSPI)this.theEvent).setUnderlying(underlying);
            this.map = Collections.emptyMap();
        }
    }
}

