/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.eventtyperepo;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariantStream;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.event.eventtypefactory.EventTypeFactory;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepositoryImpl;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.event.variant.VariantSpec;
import com.espertech.esper.common.internal.util.CRC32Util;
import java.util.LinkedHashSet;
import java.util.Map;

public class EventTypeRepositoryVariantStreamUtil {
    public static void buildVariantStreams(EventTypeRepositoryImpl repo, Map<String, ConfigurationCommonVariantStream> variantStreams, EventTypeFactory eventTypeFactory) {
        for (Map.Entry<String, ConfigurationCommonVariantStream> entry : variantStreams.entrySet()) {
            if (repo.getTypeByName(entry.getKey()) != null) continue;
            EventTypeRepositoryVariantStreamUtil.addVariantStream(entry.getKey(), entry.getValue(), repo, eventTypeFactory);
        }
    }

    private static VariantSpec validateVariantStream(String variantStreamname, ConfigurationCommonVariantStream variantStreamConfig, EventTypeRepositoryImpl repo) {
        if (variantStreamConfig.getTypeVariance() == ConfigurationCommonVariantStream.TypeVariance.PREDEFINED && variantStreamConfig.getVariantTypeNames().isEmpty()) {
            throw new ConfigurationException("Invalid variant stream configuration, no event type name has been added and default type variance requires at least one type, for name '" + variantStreamname + "'");
        }
        LinkedHashSet<EventType> types = new LinkedHashSet<EventType>();
        for (String typeName : variantStreamConfig.getVariantTypeNames()) {
            EventType type = repo.getTypeByName(typeName);
            if (type == null) {
                throw new ConfigurationException("Event type by name '" + typeName + "' could not be found for use in variant stream configuration by name '" + variantStreamname + "'");
            }
            types.add(type);
        }
        EventType[] eventTypes = types.toArray(new EventType[types.size()]);
        return new VariantSpec(eventTypes, variantStreamConfig.getTypeVariance());
    }

    private static void addVariantStream(String name, ConfigurationCommonVariantStream config, EventTypeRepositoryImpl repo, EventTypeFactory eventTypeFactory) {
        VariantSpec variantSpec = EventTypeRepositoryVariantStreamUtil.validateVariantStream(name, config, repo);
        EventTypeMetadata metadata = new EventTypeMetadata(name, null, EventTypeTypeClass.VARIANT, EventTypeApplicationType.VARIANT, NameAccessModifier.PRECONFIGURED, EventTypeBusModifier.BUS, false, new EventTypeIdPair(CRC32Util.computeCRC32(name), -1L));
        VariantEventType variantEventType = eventTypeFactory.createVariant(metadata, variantSpec);
        repo.addType(variantEventType);
    }
}

