/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.JsonSchema;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeWithSupertype;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.util.IdentifierUtil;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.util.ParentClassLoader;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventTypeForgablesPair;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.json.compiletime.JsonApplicationClassDelegateDesc;
import com.espertech.esper.common.internal.event.json.compiletime.JsonEventTypeUtilityReflective;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDelegate;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDelegateFactory;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDesc;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonUnderlying;
import com.espertech.esper.common.internal.event.json.core.EventTypeNestableGetterFactoryJson;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventTypeDetail;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeNull;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeFactoryBuiltinClassTyped;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeFactoryEventTypeTyped;
import com.espertech.esper.common.internal.event.json.write.JsonWriteForgeNull;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.ConstructorHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsonEventTypeUtility {
    public static JsonEventType makeJsonTypeCompileTimeExistingType(EventTypeMetadata metadata, JsonEventType existingType, StatementCompileTimeServices services) {
        EventTypeNestableGetterFactoryJson getterFactoryJson = new EventTypeNestableGetterFactoryJson(existingType.getDetail());
        return new JsonEventType(metadata, existingType.getTypes(), null, Collections.emptySet(), existingType.getStartTimestampPropertyName(), existingType.getEndTimestampPropertyName(), getterFactoryJson, services.getBeanEventTypeFactoryPrivate(), existingType.getDetail(), existingType.getUnderlyingEPType());
    }

    public static EventTypeForgablesPair makeJsonTypeCompileTimeNewType(EventTypeMetadata metadata, Map<String, Object> compiledTyping, Pair<EventType[], Set<EventType>> superTypes, ConfigurationCommonEventTypeWithSupertype config, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        Object jsonClassNameSimple;
        Map<String, Field> fields;
        LinkedHashMap<EPTypeClass, JsonApplicationClassDelegateDesc> deepClasses;
        Map<String, String> fieldNames;
        Map<String, Object> properties;
        if (metadata.getApplicationType() != EventTypeApplicationType.JSON) {
            throw new IllegalStateException("Expected Json application type");
        }
        JsonEventType optionalSuperType = (JsonEventType)(superTypes == null ? null : (superTypes.getFirst() == null || superTypes.getFirst().length == 0 ? null : superTypes.getFirst()[0]));
        int numFieldsSuperType = optionalSuperType == null ? 0 : optionalSuperType.getDetail().getFieldDescriptors().size();
        JsonSchema jsonSchema = (JsonSchema)AnnotationUtil.findAnnotation(raw.getAnnotations(), JsonSchema.class);
        boolean dynamic = JsonEventTypeUtility.determineDynamic(jsonSchema, optionalSuperType, raw);
        final EPTypeClass optionalUnderlyingProvided = JsonEventTypeUtility.determineUnderlyingProvided(jsonSchema, services);
        if (optionalUnderlyingProvided == null) {
            properties = BaseNestableEventUtil.resolvePropertyTypes(compiledTyping, services.getEventTypeCompileTimeResolver());
            properties = JsonEventTypeUtility.removeEventBeanTypes(properties);
            fieldNames = JsonEventTypeUtility.computeFieldNames(properties);
            deepClasses = JsonEventTypeUtilityReflective.computeClassesDeep(properties, metadata.getName(), raw.getAnnotations(), services);
            fields = Collections.emptyMap();
        } else {
            if (dynamic) {
                throw new ExprValidationException("The dynamic flag is not supported when used with a provided JSON event class");
            }
            if (optionalSuperType != null) {
                throw new ExprValidationException("Specifying a supertype is not supported with a provided JSON event class");
            }
            if (!Modifier.isPublic(optionalUnderlyingProvided.getType().getModifiers())) {
                throw new ExprValidationException("Provided JSON event class is not public");
            }
            if (!ConstructorHelper.hasDefaultConstructor(optionalUnderlyingProvided.getType())) {
                throw new ExprValidationException("Provided JSON event class does not have a public default constructor or is a non-static inner class");
            }
            deepClasses = JsonEventTypeUtilityReflective.computeClassesDeep(optionalUnderlyingProvided, metadata.getName(), raw.getAnnotations(), services);
            fields = new LinkedHashMap();
            ((JsonApplicationClassDelegateDesc)deepClasses.get(optionalUnderlyingProvided)).getFields().forEach(field -> fields.put(field.getName(), (Field)field));
            properties = JsonEventTypeUtility.resolvePropertiesFromFields(fields);
            fieldNames = JsonEventTypeUtility.computeFieldNamesFromProperties(properties);
            compiledTyping = BaseNestableEventUtil.resolvePropertyTypes(compiledTyping, services.getEventTypeCompileTimeResolver());
            JsonEventTypeUtility.validateFieldTypes(optionalUnderlyingProvided.getType(), fields, compiledTyping);
            for (Map.Entry<String, Object> compiledTypingEntry : compiledTyping.entrySet()) {
                if (!(compiledTypingEntry.getValue() instanceof TypeBeanOrUnderlying) && !(compiledTypingEntry.getValue() instanceof TypeBeanOrUnderlying[])) continue;
                properties.put(compiledTypingEntry.getKey(), compiledTypingEntry.getValue());
            }
        }
        Map<String, JsonUnderlyingField> fieldDescriptors = JsonEventTypeUtility.computeFields(properties, fieldNames, optionalSuperType, fields);
        Map<String, JsonForgeDesc> forges = JsonEventTypeUtility.computeValueForges(properties, fields, deepClasses, raw.getAnnotations(), services);
        if (optionalUnderlyingProvided != null) {
            jsonClassNameSimple = optionalUnderlyingProvided.getType().getSimpleName();
        } else {
            jsonClassNameSimple = metadata.getName();
            if (metadata.getAccessModifier().isPrivateOrTransient()) {
                String uuid = CodeGenerationIDGenerator.generateClassNameUUID();
                jsonClassNameSimple = (String)jsonClassNameSimple + "__" + uuid;
            } else if (raw.getModuleName() != null) {
                String moduleNameEscapeDot = raw.getModuleName().replace(".", "_DOT_");
                jsonClassNameSimple = (String)jsonClassNameSimple + "__module_" + moduleNameEscapeDot;
            }
        }
        StmtClassForgeableJsonDesc forgeableDesc = new StmtClassForgeableJsonDesc(properties, fieldDescriptors, dynamic, numFieldsSuperType, optionalSuperType, forges);
        Object underlyingClassNameSimple = jsonClassNameSimple;
        Object underlyingClassNameForReference = optionalUnderlyingProvided != null ? optionalUnderlyingProvided.getTypeName() : underlyingClassNameSimple;
        StmtClassForgeableFactory underlying = new StmtClassForgeableFactory(){
            final /* synthetic */ String val$underlyingClassNameSimple;
            final /* synthetic */ StmtClassForgeableJsonDesc val$forgeableDesc;
            {
                this.val$underlyingClassNameSimple = string;
                this.val$forgeableDesc = stmtClassForgeableJsonDesc;
            }

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableJsonUnderlying(this.val$underlyingClassNameSimple, packageScope, this.val$forgeableDesc);
            }
        };
        final String delegateClassNameSimple = (String)jsonClassNameSimple + "__Delegate";
        StmtClassForgeableFactory delegate = new StmtClassForgeableFactory(){
            final /* synthetic */ String val$underlyingClassNameForReference;
            final /* synthetic */ StmtClassForgeableJsonDesc val$forgeableDesc;
            {
                this.val$underlyingClassNameForReference = string2;
                this.val$forgeableDesc = stmtClassForgeableJsonDesc;
            }

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableJsonDelegate(CodegenClassType.JSONDELEGATE, delegateClassNameSimple, packageScope, this.val$underlyingClassNameForReference, this.val$forgeableDesc);
            }
        };
        final String delegateFactoryClassNameSimple = (String)jsonClassNameSimple + "__Factory";
        StmtClassForgeableFactory delegateFactory = new StmtClassForgeableFactory(){
            final /* synthetic */ String val$underlyingClassNameForReference;
            final /* synthetic */ StmtClassForgeableJsonDesc val$forgeableDesc;
            {
                this.val$underlyingClassNameForReference = string3;
                this.val$forgeableDesc = stmtClassForgeableJsonDesc;
            }

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableJsonDelegateFactory(CodegenClassType.JSONDELEGATEFACTORY, delegateFactoryClassNameSimple, optionalUnderlyingProvided != null, packageScope, delegateClassNameSimple, this.val$underlyingClassNameForReference, this.val$forgeableDesc);
            }
        };
        String underlyingClassNameFull = optionalUnderlyingProvided == null ? services.getPackageName() + "." + (String)underlyingClassNameSimple : optionalUnderlyingProvided.getTypeName();
        String delegateClassNameFull = services.getPackageName() + "." + delegateClassNameSimple;
        String delegateFactoryClassNameFull = services.getPackageName() + "." + delegateFactoryClassNameSimple;
        String serdeClassNameFull = services.getPackageName() + "." + (String)jsonClassNameSimple + "__" + metadata.getName() + "__Serde";
        JsonEventTypeDetail detail = new JsonEventTypeDetail(underlyingClassNameFull, optionalUnderlyingProvided == null ? null : optionalUnderlyingProvided.getType(), delegateClassNameFull, delegateFactoryClassNameFull, serdeClassNameFull, fieldDescriptors, dynamic, numFieldsSuperType);
        EventTypeNestableGetterFactoryJson getterFactoryJson = new EventTypeNestableGetterFactoryJson(detail);
        Class standIn = optionalUnderlyingProvided == null ? services.getCompilerServices().compileStandInClass(CodegenClassType.JSONEVENT, (String)underlyingClassNameSimple, services.getServices()) : optionalUnderlyingProvided.getType();
        JsonEventType eventType = new JsonEventType(metadata, properties, superTypes == null ? new EventType[]{} : superTypes.getFirst(), superTypes == null ? Collections.emptySet() : superTypes.getSecond(), config == null ? null : config.getStartTimestampPropertyName(), config == null ? null : config.getEndTimestampPropertyName(), getterFactoryJson, services.getBeanEventTypeFactoryPrivate(), detail, ClassHelperGenericType.getClassEPType(standIn));
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(3);
        JsonEventTypeUtility.generateApplicationClassForgables(optionalUnderlyingProvided, deepClasses, additionalForgeables, raw.getAnnotations(), services);
        if (optionalUnderlyingProvided == null) {
            additionalForgeables.add(underlying);
        }
        additionalForgeables.add(delegate);
        additionalForgeables.add(delegateFactory);
        return new EventTypeForgablesPair(eventType, additionalForgeables);
    }

    private static void validateFieldTypes(Class declaredClass, Map<String, Field> targetFields, Map<String, Object> insertedFields) throws ExprValidationException {
        for (Map.Entry<String, Object> inserted : insertedFields.entrySet()) {
            EventType eventType;
            String insertedName = inserted.getKey();
            Object insertedType = inserted.getValue();
            Field field = targetFields.get(insertedName);
            if (field == null) {
                throw new ExprValidationException("Failed to find public field '" + insertedName + "' on class '" + declaredClass.getName() + "'");
            }
            Class<?> fieldClass = JavaClassHelper.getBoxedType(field.getType());
            if (insertedType instanceof EPTypeClass) {
                Class<?> insertedClass = JavaClassHelper.getBoxedType(((EPTypeClass)insertedType).getType());
                if (JavaClassHelper.isSubclassOrImplementsInterface(insertedClass, fieldClass)) continue;
                throw JsonEventTypeUtility.makeInvalidField(insertedName, insertedClass, declaredClass, field);
            }
            if (insertedType instanceof TypeBeanOrUnderlying || insertedType instanceof EventType) {
                eventType = insertedType instanceof TypeBeanOrUnderlying ? ((TypeBeanOrUnderlying)insertedType).getEventType() : (EventType)insertedType;
                if (JavaClassHelper.isSubclassOrImplementsInterface(eventType.getUnderlyingType(), fieldClass)) continue;
                throw JsonEventTypeUtility.makeInvalidField(insertedName, eventType.getUnderlyingType(), declaredClass, field);
            }
            if (insertedType instanceof TypeBeanOrUnderlying[] || insertedType instanceof EventType[]) {
                EventType eventType2 = eventType = insertedType instanceof TypeBeanOrUnderlying[] ? ((TypeBeanOrUnderlying[])insertedType)[0].getEventType() : ((EventType[])insertedType)[0];
                if (fieldClass.isArray() && JavaClassHelper.isSubclassOrImplementsInterface(eventType.getUnderlyingType(), fieldClass.getComponentType())) continue;
                throw JsonEventTypeUtility.makeInvalidField(insertedName, eventType.getUnderlyingType(), declaredClass, field);
            }
            throw new IllegalStateException("Unrecognized type '" + insertedType + "'");
        }
    }

    private static ExprValidationException makeInvalidField(String insertedName, Class insertedClass, Class declaredClass, Field field) {
        return new ExprValidationException("Public field '" + insertedName + "' of class '" + ClassHelperPrint.getClassNameFullyQualPretty(declaredClass) + "' declared as type '" + ClassHelperPrint.getClassNameFullyQualPretty(field.getType()) + "' cannot receive a value of type '" + ClassHelperPrint.getClassNameFullyQualPretty(insertedClass) + "'");
    }

    private static void generateApplicationClassForgables(EPTypeClass optionalUnderlyingProvided, Map<EPTypeClass, JsonApplicationClassDelegateDesc> deepClasses, List<StmtClassForgeableFactory> additionalForgeables, Annotation[] annotations, StatementCompileTimeServices services) throws ExprValidationException {
        for (final Map.Entry<EPTypeClass, JsonApplicationClassDelegateDesc> entry : deepClasses.entrySet()) {
            if (entry.getKey().equals(optionalUnderlyingProvided)) continue;
            LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
            entry.getValue().getFields().forEach(field -> fields.put(field.getName(), (Field)field));
            Map<String, Object> properties = JsonEventTypeUtility.resolvePropertiesFromFields(fields);
            Map<String, String> fieldNames = JsonEventTypeUtility.computeFieldNamesFromProperties(properties);
            Map<String, JsonForgeDesc> forges = JsonEventTypeUtility.computeValueForges(properties, fields, deepClasses, annotations, services);
            Map<String, JsonUnderlyingField> fieldDescriptors = JsonEventTypeUtility.computeFields(properties, fieldNames, null, fields);
            final String delegateClassNameSimple = entry.getValue().getDelegateClassName();
            final StmtClassForgeableJsonDesc forgeableDesc = new StmtClassForgeableJsonDesc(properties, fieldDescriptors, false, 0, null, forges);
            StmtClassForgeableFactory delegate = new StmtClassForgeableFactory(){

                @Override
                public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                    return new StmtClassForgeableJsonDelegate(CodegenClassType.JSONNESTEDCLASSDELEGATEANDFACTORY, delegateClassNameSimple, packageScope, ((EPTypeClass)entry.getKey()).getTypeName(), forgeableDesc);
                }
            };
            final String delegateFactoryClassNameSimple = entry.getValue().getDelegateFactoryClassName();
            StmtClassForgeableFactory delegateFactory = new StmtClassForgeableFactory(){

                @Override
                public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                    return new StmtClassForgeableJsonDelegateFactory(CodegenClassType.JSONNESTEDCLASSDELEGATEANDFACTORY, delegateFactoryClassNameSimple, true, packageScope, delegateClassNameSimple, ((EPTypeClass)entry.getKey()).getTypeName(), forgeableDesc);
                }
            };
            additionalForgeables.add(delegate);
            additionalForgeables.add(delegateFactory);
        }
    }

    private static Map<String, String> computeFieldNamesFromProperties(Map<String, Object> properties) {
        LinkedHashMap<String, String> fieldNames = new LinkedHashMap<String, String>();
        for (String key : properties.keySet()) {
            fieldNames.put(key, key);
        }
        return fieldNames;
    }

    private static EPTypeClass determineUnderlyingProvided(JsonSchema jsonSchema, StatementCompileTimeServices services) throws ExprValidationException {
        if (jsonSchema != null && !jsonSchema.className().trim().isEmpty()) {
            try {
                Class clazz = services.getClasspathImportServiceCompileTime().resolveClass(jsonSchema.className(), true, ClasspathExtensionClassEmpty.INSTANCE);
                return ClassHelperGenericType.getClassEPType(clazz);
            }
            catch (ClasspathImportException e) {
                throw new ExprValidationException("Failed to resolve JSON event class '" + jsonSchema.className() + "': " + e.getMessage(), e);
            }
        }
        return null;
    }

    private static boolean determineDynamic(JsonSchema jsonSchema, JsonEventType optionalSuperType, StatementRawInfo raw) {
        if (optionalSuperType != null && optionalSuperType.getDetail().isDynamic()) {
            return true;
        }
        return jsonSchema != null && jsonSchema.dynamic();
    }

    private static Map<String, Object> removeEventBeanTypes(Map<String, Object> properties) {
        LinkedHashMap<String, Object> verified = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> prop : properties.entrySet()) {
            EventType eventType;
            String propertyName = prop.getKey();
            Object propertyType = prop.getValue();
            verified.put(propertyName, propertyType);
            if (propertyType instanceof EventType) {
                eventType = (EventType)propertyType;
                verified.put(propertyName, new TypeBeanOrUnderlying(eventType));
                continue;
            }
            if (!(propertyType instanceof EventType[])) continue;
            eventType = ((EventType[])propertyType)[0];
            verified.put(propertyName, new TypeBeanOrUnderlying[]{new TypeBeanOrUnderlying(eventType)});
        }
        return verified;
    }

    private static Map<String, JsonForgeDesc> computeValueForges(Map<String, Object> compiledTyping, Map<String, Field> fields, Map<EPTypeClass, JsonApplicationClassDelegateDesc> deepClasses, Annotation[] annotations, StatementCompileTimeServices services) throws ExprValidationException {
        HashMap<String, JsonForgeDesc> valueForges = new HashMap<String, JsonForgeDesc>();
        for (Map.Entry<String, Object> entry : compiledTyping.entrySet()) {
            JsonForgeDesc forgeDesc;
            Object type = entry.getValue();
            Field optionalField = fields.get(entry.getKey());
            if (type == null || type == EPTypeNull.INSTANCE) {
                forgeDesc = new JsonForgeDesc(entry.getKey(), null, null, JsonEndValueForgeNull.INSTANCE, JsonWriteForgeNull.INSTANCE);
            } else if (type instanceof EPTypeClass) {
                EPTypeClass clazz = (EPTypeClass)type;
                forgeDesc = JsonForgeFactoryBuiltinClassTyped.forge(clazz, entry.getKey(), optionalField, deepClasses, annotations, services);
            } else if (type instanceof TypeBeanOrUnderlying) {
                eventType = ((TypeBeanOrUnderlying)type).getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(eventType);
                forgeDesc = eventType instanceof JsonEventType ? JsonForgeFactoryEventTypeTyped.forgeNonArray(entry.getKey(), (JsonEventType)eventType) : JsonForgeFactoryBuiltinClassTyped.forge(EPTypePremade.MAP.getEPType(), entry.getKey(), optionalField, deepClasses, annotations, services);
            } else if (type instanceof TypeBeanOrUnderlying[]) {
                eventType = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(eventType);
                forgeDesc = eventType instanceof JsonEventType ? JsonForgeFactoryEventTypeTyped.forgeArray(entry.getKey(), (JsonEventType)eventType) : JsonForgeFactoryBuiltinClassTyped.forge(EPTypePremade.MAPARRAY.getEPType(), entry.getKey(), optionalField, deepClasses, annotations, services);
            } else {
                throw new IllegalStateException("Unrecognized type " + type);
            }
            valueForges.put(entry.getKey(), forgeDesc);
        }
        return valueForges;
    }

    private static void validateJsonOrMapType(EventType eventType) throws ExprValidationException {
        if (!(eventType instanceof JsonEventType) && !(eventType instanceof MapEventType)) {
            throw new ExprValidationException("Failed to validate event type '" + eventType.getMetadata().getName() + "', expected a Json or Map event type");
        }
    }

    private static Map<String, JsonUnderlyingField> computeFields(Map<String, Object> compiledTyping, Map<String, String> fieldNames, JsonEventType optionalSuperType, Map<String, Field> fields) throws ExprValidationException {
        LinkedHashMap<String, JsonUnderlyingField> allFieldsInclSupertype = new LinkedHashMap<String, JsonUnderlyingField>();
        int index = 0;
        if (optionalSuperType != null) {
            allFieldsInclSupertype.putAll(optionalSuperType.getDetail().getFieldDescriptors());
            index = allFieldsInclSupertype.size();
        }
        for (Map.Entry<String, Object> entry : compiledTyping.entrySet()) {
            EPTypeClass assignedType;
            String fieldName = fieldNames.get(entry.getKey());
            Object type = entry.getValue();
            if (type == null || type == EPTypeNull.INSTANCE) {
                assignedType = EPTypePremade.OBJECT.getEPType();
            } else if (type instanceof EPTypeClass) {
                assignedType = (EPTypeClass)type;
            } else if (type instanceof TypeBeanOrUnderlying) {
                other = ((TypeBeanOrUnderlying)type).getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(other);
                assignedType = JsonEventTypeUtility.getAssignedType(other);
            } else if (type instanceof TypeBeanOrUnderlying[]) {
                other = ((TypeBeanOrUnderlying[])type)[0].getEventType();
                JsonEventTypeUtility.validateJsonOrMapType(other);
                assignedType = JavaClassHelper.getArrayType(JsonEventTypeUtility.getAssignedType(other));
            } else {
                throw new IllegalStateException("Unrecognized type " + type);
            }
            allFieldsInclSupertype.put(entry.getKey(), new JsonUnderlyingField(fieldName, index, assignedType, fields.get(fieldName)));
            ++index;
        }
        return allFieldsInclSupertype;
    }

    private static EPTypeClass getAssignedType(EventType type) throws ExprValidationException {
        if (type instanceof JsonEventType || type instanceof MapEventType) {
            return type.getUnderlyingEPType();
        }
        throw new ExprValidationException("Incompatible type '" + type.getName() + "' encountered, expected a Json or Map event type");
    }

    private static Map<String, String> computeFieldNames(Map<String, Object> compiledTyping) {
        HashMap<String, String> fields = new HashMap<String, String>();
        HashSet<CallSite> assignedNames = new HashSet<CallSite>();
        for (String name : compiledTyping.keySet()) {
            String assigned = "_" + IdentifierUtil.getIdentifierMayStartNumeric(name.toLowerCase(Locale.ENGLISH));
            if (!assignedNames.add((CallSite)((Object)assigned))) {
                int suffix = 0;
                while (true) {
                    String withSuffix;
                    if (!assignedNames.contains(withSuffix = assigned + "_" + suffix)) {
                        assigned = withSuffix;
                        assignedNames.add((CallSite)((Object)assigned));
                        break;
                    }
                    ++suffix;
                }
            }
            fields.put(name, assigned);
        }
        return fields;
    }

    public static void addJsonUnderlyingClass(Map<String, EventType> moduleTypes, ParentClassLoader classLoaderParent, String optionalDeploymentId) {
        for (Map.Entry<String, EventType> eventType : moduleTypes.entrySet()) {
            JsonEventTypeUtility.addJsonUnderlyingClass(eventType.getValue(), classLoaderParent, optionalDeploymentId);
        }
    }

    public static void addJsonUnderlyingClass(PathRegistry<String, EventType> pathEventTypes, ParentClassLoader classLoaderParent) {
        pathEventTypes.traverse(type -> JsonEventTypeUtility.addJsonUnderlyingClass(type, classLoaderParent, null));
    }

    public static void addJsonUnderlyingClass(EventType eventType, ParentClassLoader classLoaderParent, String optionalDeploymentId) {
        boolean allowDuplicate;
        if (!(eventType instanceof JsonEventType)) {
            return;
        }
        JsonEventType jsonEventType = (JsonEventType)eventType;
        boolean bl = allowDuplicate = eventType.getMetadata().getTypeClass() == EventTypeTypeClass.NAMED_WINDOW;
        if (jsonEventType.getDetail().getOptionalUnderlyingProvided() == null) {
            classLoaderParent.add(jsonEventType.getDetail().getUnderlyingClassName(), jsonEventType.getUnderlyingType(), optionalDeploymentId, allowDuplicate);
        } else {
            allowDuplicate = true;
        }
        classLoaderParent.add(jsonEventType.getDetail().getDelegateClassName(), jsonEventType.getDelegateType(), optionalDeploymentId, allowDuplicate);
        classLoaderParent.add(jsonEventType.getDetail().getDelegateFactoryClassName(), jsonEventType.getDelegateFactory().getClass(), optionalDeploymentId, allowDuplicate);
    }

    private static Map<String, Object> resolvePropertiesFromFields(Map<String, Field> fields) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(CollectionUtil.capacityHashMap(fields.size()));
        for (Map.Entry<String, Field> field : fields.entrySet()) {
            EPTypeClass type = ClassHelperGenericType.getFieldEPType(field.getValue());
            properties.put(field.getKey(), type);
        }
        return properties;
    }
}

