/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.getter.provided.JsonFieldResolverProvided;
import java.lang.reflect.Field;

public class JsonUnderlyingField {
    public static final EPTypeClass EPTYPE = new EPTypeClass(JsonUnderlyingField.class);
    private final String fieldName;
    private final int propertyNumber;
    private final EPTypeClass propertyType;
    private final Field optionalField;

    public JsonUnderlyingField(String fieldName, int propertyNumber, EPTypeClass propertyType, Field optionalField) {
        this.fieldName = fieldName;
        this.propertyNumber = propertyNumber;
        this.propertyType = propertyType;
        this.optionalField = optionalField;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getPropertyNumber() {
        return this.propertyNumber;
    }

    public EPTypeClass getPropertyType() {
        return this.propertyType;
    }

    public Field getOptionalField() {
        return this.optionalField;
    }

    public CodegenExpression toExpression() {
        CodegenExpression field = CodegenExpressionBuilder.constantNull();
        if (this.optionalField != null) {
            field = CodegenExpressionBuilder.staticMethod(JsonFieldResolverProvided.class, "resolveJsonField", CodegenExpressionBuilder.constant(this.optionalField.getDeclaringClass()), CodegenExpressionBuilder.constant(this.optionalField.getName()));
        }
        return CodegenExpressionBuilder.newInstance(EPTYPE, CodegenExpressionBuilder.constant(this.fieldName), CodegenExpressionBuilder.constant(this.propertyNumber), CodegenExpressionBuilder.constant(this.propertyType), field);
    }
}

