/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.compiletime;

import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableRSPFactoryProvider;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.event.json.compiletime.StmtClassForgeableJsonDesc;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateBase;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateJsonGenericArray;
import com.espertech.esper.common.internal.event.json.parser.core.JsonDelegateJsonGenericObject;
import com.espertech.esper.common.internal.event.json.parser.core.JsonHandlerDelegator;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonDelegateRefs;
import com.espertech.esper.common.internal.event.json.parser.forge.JsonForgeDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StmtClassForgeableJsonDelegate
implements StmtClassForgeable {
    private final CodegenClassType classType;
    private final String className;
    private final CodegenPackageScope packageScope;
    private final String underlyingClassName;
    private final StmtClassForgeableJsonDesc desc;

    public StmtClassForgeableJsonDelegate(CodegenClassType classType, String className, CodegenPackageScope packageScope, String underlyingClassName, StmtClassForgeableJsonDesc desc) {
        this.classType = classType;
        this.className = className;
        this.packageScope = packageScope;
        this.underlyingClassName = underlyingClassName;
        this.desc = desc;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>(2);
        members.add(new CodegenTypedParam(this.underlyingClassName, "bean"));
        CodegenTypedParam delegatorParam = new CodegenTypedParam(JsonHandlerDelegator.EPTYPE, "delegator", false, false);
        CodegenTypedParam parentParam = new CodegenTypedParam(JsonDelegateBase.EPTYPE, "parent", false, false);
        CodegenTypedParam beanParam = new CodegenTypedParam(this.underlyingClassName, "bean", false, false);
        List<CodegenTypedParam> ctorParams = Arrays.asList(delegatorParam, parentParam, beanParam);
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, classScope, ctorParams);
        if (this.desc.getOptionalSupertype() != null) {
            ctor.getBlock().superCtor(CodegenExpressionBuilder.ref("delegator"), CodegenExpressionBuilder.ref("parent"), CodegenExpressionBuilder.ref("bean"));
        } else {
            ctor.getBlock().superCtor(CodegenExpressionBuilder.ref("delegator"), CodegenExpressionBuilder.ref("parent"));
        }
        ctor.getBlock().assignRef(CodegenExpressionBuilder.ref("this.bean"), (CodegenExpression)CodegenExpressionBuilder.ref("bean"));
        CodegenMethod startObjectMethod = CodegenMethod.makeParentNode(JsonDelegateBase.EPTYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.STRING.getEPType(), "name");
        if (this.desc.getOptionalSupertype() != null) {
            startObjectMethod.getBlock().declareVar(JsonDelegateBase.EPTYPE, "delegate", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "startObject", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("delegate"))).blockReturn(CodegenExpressionBuilder.ref("delegate"));
        }
        for (String property : this.desc.getPropertiesThisType().keySet()) {
            JsonForgeDesc forge = this.desc.getForges().get(property);
            if (forge.getOptionalStartObjectForge() == null) continue;
            startObjectMethod.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(property))).blockReturn(forge.getOptionalStartObjectForge().newDelegate(JsonDelegateRefs.INSTANCE, startObjectMethod, classScope));
        }
        CodegenExpression resultStartObject = this.desc.isDynamic() ? CodegenExpressionBuilder.newInstance(JsonDelegateJsonGenericObject.EPTYPE, JsonDelegateRefs.INSTANCE.getBaseHandler(), JsonDelegateRefs.INSTANCE.getThis()) : CodegenExpressionBuilder.constantNull();
        startObjectMethod.getBlock().methodReturn(resultStartObject);
        CodegenMethod startArrayMethod = CodegenMethod.makeParentNode(JsonDelegateBase.EPTYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.STRING.getEPType(), "name");
        if (this.desc.getOptionalSupertype() != null) {
            startArrayMethod.getBlock().declareVar(JsonDelegateBase.EPTYPE, "delegate", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "startArray", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("delegate"))).blockReturn(CodegenExpressionBuilder.ref("delegate"));
        }
        for (String property : this.desc.getPropertiesThisType().keySet()) {
            JsonForgeDesc forge = this.desc.getForges().get(property);
            if (forge.getOptionalStartArrayForge() == null) continue;
            startArrayMethod.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(property))).blockReturn(forge.getOptionalStartArrayForge().newDelegate(JsonDelegateRefs.INSTANCE, startArrayMethod, classScope));
        }
        CodegenExpression resultStartArray = this.desc.isDynamic() ? CodegenExpressionBuilder.newInstance(JsonDelegateJsonGenericArray.EPTYPE, JsonDelegateRefs.INSTANCE.getBaseHandler(), JsonDelegateRefs.INSTANCE.getThis()) : CodegenExpressionBuilder.constantNull();
        startArrayMethod.getBlock().methodReturn(resultStartArray);
        CodegenMethod endObjectValueMethod = CodegenMethod.makeParentNode(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.STRING.getEPType(), "name");
        if (this.desc.getOptionalSupertype() != null) {
            endObjectValueMethod.getBlock().declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "handled", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("super"), "endObjectValue", CodegenExpressionBuilder.ref("name"))).ifCondition(CodegenExpressionBuilder.ref("handled")).blockReturn(CodegenExpressionBuilder.constantTrue());
        }
        for (Map.Entry entry : this.desc.getPropertiesThisType().entrySet()) {
            if (entry.getValue() == EPTypeNull.INSTANCE) continue;
            String fieldName = this.desc.getFieldDescriptorsInclSupertype().get(entry.getKey()).getFieldName();
            JsonForgeDesc forge = this.desc.getForges().get(entry.getKey());
            CodegenExpression value = forge.getEndValueForge().captureValue(JsonEndValueRefs.INSTANCE, endObjectValueMethod, classScope);
            endObjectValueMethod.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("name"), "equals", CodegenExpressionBuilder.constant(entry.getKey()))).assignRef(CodegenExpressionBuilder.ref("bean." + fieldName), value).blockReturn(CodegenExpressionBuilder.constantTrue());
        }
        if (this.desc.isDynamic()) {
            endObjectValueMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("this"), "addGeneralJson", CodegenExpressionBuilder.ref("bean.__dyn"), CodegenExpressionBuilder.ref("name"));
        }
        endObjectValueMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantFalse());
        CodegenMethod getResultMethod = CodegenMethod.makeParentNode(this.underlyingClassName, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope);
        getResultMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("bean"));
        CodegenClassMethods codegenClassMethods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(startObjectMethod, "startObject", codegenClassMethods);
        CodegenStackGenerator.recursiveBuildStack(startArrayMethod, "startArray", codegenClassMethods);
        CodegenStackGenerator.recursiveBuildStack(endObjectValueMethod, "endObjectValue", codegenClassMethods);
        CodegenStackGenerator.recursiveBuildStack(getResultMethod, "getResult", codegenClassMethods);
        CodegenClass clazz = new CodegenClass(this.classType, this.className, classScope, members, ctor, codegenClassMethods, Collections.emptyList());
        if (this.desc.getOptionalSupertype() == null) {
            clazz.getSupers().setClassExtended(JsonDelegateBase.EPTYPE);
        } else {
            clazz.getSupers().setClassExtended(this.desc.getOptionalSupertype().getDetail().getDelegateClassName());
        }
        return clazz;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.JSONDELEGATE;
    }
}

