/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.core;

import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingEntrySetIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class JsonEventUnderlyingEntrySet
implements Set<Map.Entry<String, Object>> {
    private final JsonEventObjectBase jeu;
    private final Set<Map.Entry<String, Object>> entrySet;

    public JsonEventUnderlyingEntrySet(JsonEventObjectBase jeu) {
        this.jeu = jeu;
        this.entrySet = jeu.getJsonValues().entrySet();
    }

    @Override
    public int size() {
        return this.jeu.size();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new JsonEventUnderlyingEntrySetIterator(this.jeu, this.entrySet);
    }

    @Override
    public boolean isEmpty() {
        return this.jeu.getNativeSize() == 0 && this.jeu.getJsonValues().isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Map.Entry[this.size()];
        this.fillArray((Map.Entry[])result);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        Iterator<Map.Entry<String, Object>> it = this.iterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int nativeSize = this.jeu.getNativeSize();
        if (nativeSize == 0) {
            return this.entrySet.toArray(a);
        }
        Map.Entry[] array = (Map.Entry[])a;
        int size = this.size();
        if (a.length >= size) {
            this.fillArray(array);
            return a;
        }
        Map.Entry[] result = new Map.Entry[this.size()];
        this.fillArray(result);
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.jeu.getNativeSize() == 0) {
            return this.entrySet.containsAll(c);
        }
        for (Object key : c) {
            if (this.contains(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Map.Entry<String, Object> stringObjectEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<String, Object>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super Map.Entry<String, Object>> filter) {
        throw new UnsupportedOperationException();
    }

    private void fillArray(Map.Entry[] result) {
        int size = this.jeu.getNativeSize();
        for (int i = 0; i < size; ++i) {
            result[i] = this.jeu.getNativeEntry(i);
        }
        Iterator<Map.Entry<String, Object>> it = this.entrySet.iterator();
        while (it.hasNext()) {
            result[size++] = it.next();
        }
    }
}

