/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.core;

import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.event.json.core.JsonEventUnderlyingValueIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public class JsonEventUnderlyingValueCollection
implements Collection<Object> {
    private final JsonEventObjectBase jeu;
    private final Collection<Object> values;

    public JsonEventUnderlyingValueCollection(JsonEventObjectBase jeu, Collection<Object> values) {
        this.jeu = jeu;
        this.values = values;
    }

    @Override
    public int size() {
        return this.jeu.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jeu.isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        this.fillArray(result);
        return result;
    }

    @Override
    public Iterator<Object> iterator() {
        return new JsonEventUnderlyingValueIterator(this.jeu, this.values.iterator());
    }

    @Override
    public boolean contains(Object value) {
        if (value == null) {
            for (int i = 0; i < this.jeu.getNativeSize(); ++i) {
                if (this.jeu.getNativeValue(i) != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.jeu.getNativeSize(); ++i) {
                if (!value.equals(this.jeu.getNativeValue(i))) continue;
                return true;
            }
        }
        return this.values.contains(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int nativeSize = this.jeu.getNativeSize();
        if (nativeSize == 0) {
            return this.values.toArray(array);
        }
        int size = this.size();
        if (array.length >= size) {
            this.fillArray(array);
            return array;
        }
        Object[] result = new Object[this.size()];
        this.fillArray(result);
        return result;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super Object> filter) {
        throw new UnsupportedOperationException();
    }

    private void fillArray(Object[] array) {
        int size = this.jeu.getNativeSize();
        for (int i = 0; i < size; ++i) {
            array[i] = this.jeu.getNativeValue(i);
        }
        Iterator<Object> it = this.values.iterator();
        while (it.hasNext()) {
            array[size++] = it.next();
        }
    }
}

