/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.getter.fromschema;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventObjectBase;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Array;

public class JsonFieldGetterHelperSchema {
    static Object getJsonSimpleProp(JsonUnderlyingField field, Object object) {
        JsonEventObjectBase und = (JsonEventObjectBase)object;
        return und.getNativeValue(field.getPropertyNumber());
    }

    public static Object getJsonIndexedProp(Object object, int propertyNumber, int index) throws PropertyAccessException {
        JsonEventObjectBase und = (JsonEventObjectBase)object;
        Object array = und.getNativeValue(propertyNumber);
        return CollectionUtil.arrayValueAtIndex(array, index);
    }

    static boolean getJsonIndexedPropExists(Object object, JsonUnderlyingField field, int index) throws PropertyAccessException {
        JsonEventObjectBase und = (JsonEventObjectBase)object;
        Object array = und.getNativeValue(field.getPropertyNumber());
        return CollectionUtil.arrayExistsAtIndex(array, index);
    }

    public static Object getJsonMappedProp(Object object, int propertyNumber, String key) throws PropertyAccessException {
        JsonEventObjectBase und = (JsonEventObjectBase)object;
        Object result = und.getNativeValue(propertyNumber);
        return CollectionUtil.getMapValueChecked(result, key);
    }

    public static boolean getJsonMappedExists(Object object, int propertyNumber, String key) throws PropertyAccessException {
        JsonEventObjectBase und = (JsonEventObjectBase)object;
        Object result = und.getNativeValue(propertyNumber);
        return CollectionUtil.getMapKeyExistsChecked(result, key);
    }

    public static EventBean handleJsonCreateFragmentSimple(JsonEventObjectBase und, int propNumber, EventType fragmentType, EventBeanTypedEventFactory factory) {
        Object prop = und.getNativeValue(propNumber);
        if (prop == null) {
            return null;
        }
        return factory.adapterForTypedJson(prop, fragmentType);
    }

    public static EventBean handleJsonCreateFragmentIndexed(JsonEventObjectBase und, int propNumber, int index, EventType fragmentType, EventBeanTypedEventFactory factory) {
        Object prop = und.getNativeValue(propNumber);
        if ((prop = CollectionUtil.arrayValueAtIndex(prop, index)) == null) {
            return null;
        }
        return factory.adapterForTypedJson(prop, fragmentType);
    }

    public static EventBean[] handleJsonCreateFragmentArray(JsonEventObjectBase und, int propNumber, EventType fragmentType, EventBeanTypedEventFactory factory) throws PropertyAccessException {
        Object value = und.getNativeValue(propNumber);
        if (value == null) {
            return null;
        }
        int len = Array.getLength(value);
        EventBean[] events = new EventBean[len];
        for (int i = 0; i < len; ++i) {
            Object item = Array.get(value, i);
            events[i] = factory.adapterForTypedJson(item, fragmentType);
        }
        return events;
    }
}

