/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.getter.provided;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.bean.getter.BaseNativePropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.json.getter.core.JsonEventPropertyGetter;
import com.espertech.esper.common.internal.event.json.getter.provided.JsonFieldGetterHelperProvided;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Field;

public final class JsonGetterIndexedProvidedBaseNative
extends BaseNativePropertyGetter
implements JsonEventPropertyGetter {
    private final Field field;
    private final int index;

    public JsonGetterIndexedProvidedBaseNative(EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory, EPTypeClass returnType, Field field, int index) {
        super(eventBeanTypedEventFactory, beanEventTypeFactory, returnType);
        this.field = field;
        this.index = index;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(ClassHelperGenericType.getClassEPType(this.field.getDeclaringClass()), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "arrayValueAtIndex", CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getName()), CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingExistsCodegen(CodegenExpressionBuilder.castUnderlying(ClassHelperGenericType.getClassEPType(this.field.getDeclaringClass()), beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "arrayExistsAtIndex", CodegenExpressionBuilder.exprDotName(underlyingExpression, this.field.getName()), CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return this.getJsonExists(eventBean.getUnderlying());
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        return this.getJsonProp(eventBean.getUnderlying());
    }

    @Override
    public Object getJsonProp(Object object) throws PropertyAccessException {
        Object value = JsonFieldGetterHelperProvided.getJsonProvidedSimpleProp(object, this.field);
        return CollectionUtil.arrayValueAtIndex(value, this.index);
    }

    @Override
    public boolean getJsonExists(Object object) throws PropertyAccessException {
        return JsonFieldGetterHelperProvided.getJsonProvidedIndexedPropExists(object, this.field, this.index);
    }

    @Override
    public Object getJsonFragment(Object object) throws PropertyAccessException {
        if (!this.isFragmentable) {
            return null;
        }
        Object value = JsonFieldGetterHelperProvided.getJsonProvidedIndexedProp(object, this.field, this.index);
        if (value == null) {
            return null;
        }
        return this.getFragmentFromValue(value);
    }

    @Override
    public EPTypeClass getTargetType() {
        return ClassHelperGenericType.getClassEPType(this.field.getDeclaringClass());
    }

    @Override
    public EPTypeClass getBeanPropType() {
        return EPTypePremade.OBJECT.getEPType();
    }
}

