/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.parser.delegates.endvalue;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForge;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueForgeUtil;
import com.espertech.esper.common.internal.event.json.parser.delegates.endvalue.JsonEndValueRefs;

public class JsonEndValueForgeInteger
implements JsonEndValueForge {
    public static final JsonEndValueForgeInteger INSTANCE = new JsonEndValueForgeInteger();

    private JsonEndValueForgeInteger() {
    }

    @Override
    public CodegenExpression captureValue(JsonEndValueRefs refs, CodegenMethod method, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.staticMethod(JsonEndValueForgeInteger.class, "jsonToInteger", refs.getValueString(), refs.getName());
    }

    public static Integer jsonToInteger(String value, String name) {
        try {
            return value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            throw JsonEndValueForgeUtil.handleNumberException(name, Integer.class, value, ex);
        }
    }

    public static Object jsonToIntegerNonNull(String stringValue) {
        return Integer.parseInt(stringValue);
    }
}

