/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.json.serde;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.json.serde.DIOJsonSerdeHelper;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DIOJsonObjectSerde
implements DataInputOutputSerde<Map<String, Object>> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOJsonObjectSerde.class);
    private static final byte NULL_TYPE = 0;
    private static final byte INT_TYPE = 1;
    private static final byte DOUBLE_TYPE = 2;
    private static final byte STRING_TYPE = 3;
    private static final byte BOOLEAN_TYPE = 4;
    private static final byte OBJECT_TYPE = 5;
    private static final byte ARRAY_TYPE = 6;
    public static final DIOJsonObjectSerde INSTANCE = new DIOJsonObjectSerde();

    private DIOJsonObjectSerde() {
    }

    @Override
    public void write(Map<String, Object> object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        this.writeMap(object, output);
    }

    @Override
    public Map<String, Object> read(DataInput input, byte[] unitKey) throws IOException {
        boolean nonNull = input.readBoolean();
        return nonNull ? this.readMap(input) : null;
    }

    private void writeMap(Map<String, Object> object, DataOutput output) throws IOException {
        output.writeInt(object.size());
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            output.writeUTF(entry.getKey());
            DIOJsonSerdeHelper.writeValue(entry.getValue(), output);
        }
    }

    private Map<String, Object> readMap(DataInput input) throws IOException {
        int size = input.readInt();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(CollectionUtil.capacityHashMap(size));
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            Object value = DIOJsonSerdeHelper.readValue(input);
            map.put(key, value);
        }
        return map;
    }
}

