/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventSender;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.util.EPRuntimeEventProcessWrapped;
import com.espertech.esper.common.internal.statement.thread.ThreadingCommon;
import java.util.Map;

public class EventSenderMap
implements EventSender {
    private final EPRuntimeEventProcessWrapped runtimeEventSender;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final MapEventType mapEventType;
    private final ThreadingCommon threadingService;

    public EventSenderMap(EPRuntimeEventProcessWrapped runtimeEventSender, MapEventType mapEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, ThreadingCommon threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.mapEventType = mapEventType;
        this.threadingService = threadingService;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public void sendEvent(Object theEvent) {
        if (!(theEvent instanceof Map)) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected " + Map.class.getName());
        }
        Map map = (Map)theEvent;
        MappedEventBean mapEvent = this.eventBeanTypedEventFactory.adapterForTypedMap(map, this.mapEventType);
        if (this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(mapEvent, this.runtimeEventSender);
        } else {
            this.runtimeEventSender.processWrappedEvent(mapEvent);
        }
    }

    @Override
    public void routeEvent(Object theEvent) {
        if (!(theEvent instanceof Map)) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected " + Map.class.getName());
        }
        Map map = (Map)theEvent;
        MappedEventBean mapEvent = this.eventBeanTypedEventFactory.adapterForTypedMap(map, this.mapEventType);
        this.runtimeEventSender.routeEventBean(mapEvent);
    }
}

