/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventTypeNestableGetterFactory;
import com.espertech.esper.common.internal.event.map.EventTypeNestableGetterFactoryMap;
import com.espertech.esper.common.internal.event.map.MapEventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.map.MapEventBeanCopyMethodWithArrayMapForge;
import com.espertech.esper.common.internal.event.map.MapEventBeanPropertyWriter;
import com.espertech.esper.common.internal.event.map.MapEventBeanPropertyWriterIndexedProp;
import com.espertech.esper.common.internal.event.map.MapEventBeanPropertyWriterMapProp;
import com.espertech.esper.common.internal.event.map.MapEventBeanWriterPerProp;
import com.espertech.esper.common.internal.event.map.MapEventBeanWriterSimpleProps;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapEventType
extends BaseNestableEventType {
    public static final EPTypeClass EPTYPE = new EPTypeClass(MapEventType.class);
    private static final EPTypeClass MAPEPTYPE = EPTypeClassParameterized.from(Map.class, String.class, Object.class);
    private static final EventTypeNestableGetterFactory GETTER_FACTORY = new EventTypeNestableGetterFactoryMap();
    protected Map<String, Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>> propertyWriters;
    protected EventPropertyDescriptor[] writablePropertyDescriptors;

    public MapEventType(EventTypeMetadata metadata, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, String startTimestampPropertyName, String endTimestampPropertyName, BeanEventTypeFactory beanEventTypeFactory) {
        super(metadata, propertyTypes, optionalSuperTypes, optionalDeepSupertypes, startTimestampPropertyName, endTimestampPropertyName, GETTER_FACTORY, beanEventTypeFactory, false);
    }

    @Override
    public final Class getUnderlyingType() {
        return Map.class;
    }

    @Override
    public EPTypeClass getUnderlyingEPType() {
        return MAPEPTYPE;
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        BaseNestableEventUtil.MapIndexedPropPair pair = BaseNestableEventUtil.getIndexedAndMappedProps(properties);
        if (pair.getMapProperties().isEmpty() && pair.getArrayProperties().isEmpty()) {
            return new MapEventBeanCopyMethodForge(this, this.beanEventTypeFactory.getEventBeanTypedEventFactory());
        }
        return new MapEventBeanCopyMethodWithArrayMapForge(this, this.beanEventTypeFactory.getEventBeanTypedEventFactory(), pair.getMapProperties(), pair.getArrayProperties());
    }

    public Object getValue(String propertyName, Map values) {
        MapEventPropertyGetter getter = (MapEventPropertyGetter)this.getGetter(propertyName);
        return getter.getMap(values);
    }

    @Override
    public MapEventBeanPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getSecond();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            MappedProperty mapProp = (MappedProperty)property;
            if (!this.propertyItems.containsKey(mapProp.getPropertyNameAtomic())) {
                return null;
            }
            return new MapEventBeanPropertyWriterMapProp(mapProp.getPropertyNameAtomic(), mapProp.getKey());
        }
        if (property instanceof IndexedProperty) {
            IndexedProperty indexedProp = (IndexedProperty)property;
            if (!this.propertyItems.containsKey(indexedProp.getPropertyNameAtomic())) {
                return null;
            }
            return new MapEventBeanPropertyWriterIndexedProp(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex());
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getFirst();
        }
        Property property = PropertyParser.parseAndWalkLaxToSimple(propertyName);
        if (property instanceof MappedProperty) {
            MapEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            MappedProperty mapProp = (MappedProperty)property;
            return new EventPropertyDescriptor(mapProp.getPropertyNameAtomic(), EPTypePremade.OBJECT.getEPType(), false, true, false, true, false);
        }
        if (property instanceof IndexedProperty) {
            MapEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new EventPropertyDescriptor(indexedProp.getPropertyNameAtomic(), EPTypePremade.OBJECT.getEPType(), true, false, true, false, false);
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writablePropertyDescriptors;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        boolean allSimpleProps = true;
        MapEventBeanPropertyWriter[] writers = new MapEventBeanPropertyWriter[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter> writerPair = this.propertyWriters.get(properties[i]);
            if (writerPair != null) {
                writers[i] = writerPair.getSecond();
                continue;
            }
            writers[i] = this.getWriter(properties[i]);
            if (writers[i] == null) {
                return null;
            }
            allSimpleProps = false;
        }
        if (allSimpleProps) {
            return new MapEventBeanWriterSimpleProps(properties);
        }
        return new MapEventBeanWriterPerProp(writers);
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writeableProps = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>> propertWritersMap = new HashMap<String, Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>>();
        for (EventPropertyDescriptor prop : this.propertyDescriptors) {
            writeableProps.add(prop);
            String propertyName = prop.getPropertyName();
            MapEventBeanPropertyWriter eventPropertyWriter = new MapEventBeanPropertyWriter(propertyName);
            propertWritersMap.put(propertyName, new Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>(prop, eventPropertyWriter));
        }
        this.propertyWriters = propertWritersMap;
        this.writablePropertyDescriptors = writeableProps.toArray(new EventPropertyDescriptor[writeableProps.size()]);
    }
}

