/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.property;

import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.event.property.DynamicProperty;
import com.espertech.esper.common.internal.event.property.NestedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.SimpleProperty;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParserNoDep;

public class PropertyParser {
    public static Property parseAndWalkLaxToSimple(String propertyName) {
        try {
            return PropertyParserNoDep.parseAndWalkLaxToSimple(propertyName, false);
        }
        catch (PropertyAccessException p) {
            return new SimpleProperty(propertyName);
        }
    }

    public static String unescapeBacktickForProperty(String unescapedPropertyName) {
        if (unescapedPropertyName.startsWith("`") && unescapedPropertyName.endsWith("`")) {
            return unescapedPropertyName.substring(1, unescapedPropertyName.length() - 1);
        }
        return unescapedPropertyName;
    }

    public static Property parseAndWalk(String propertyNested, boolean isRootedDynamic) {
        return PropertyParserNoDep.parseAndWalkLaxToSimple(propertyNested, isRootedDynamic);
    }

    public static boolean isPropertyDynamic(Property prop) {
        if (prop instanceof DynamicProperty) {
            return true;
        }
        if (!(prop instanceof NestedProperty)) {
            return false;
        }
        NestedProperty nestedProperty = (NestedProperty)prop;
        for (Property property : nestedProperty.getProperties()) {
            if (!PropertyParser.isPropertyDynamic(property)) continue;
            return true;
        }
        return false;
    }
}

