/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.propertyparser;

import com.espertech.esper.common.internal.event.property.DynamicIndexedProperty;
import com.espertech.esper.common.internal.event.property.DynamicMappedProperty;
import com.espertech.esper.common.internal.event.property.DynamicSimpleProperty;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.NestedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.property.SimpleProperty;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParseNodepException;
import com.espertech.esper.common.internal.event.propertyparser.Token;
import com.espertech.esper.common.internal.event.propertyparser.TokenType;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class PropertyTokenParser {
    private final ArrayDeque<Token> tokens;
    private Token lookahead;
    private boolean dynamic;

    public PropertyTokenParser(ArrayDeque<Token> tokens, boolean rootedDynamic) {
        if (tokens.isEmpty()) {
            throw new PropertyParseNodepException("Empty property name");
        }
        this.lookahead = tokens.getFirst();
        this.tokens = tokens;
        this.dynamic = rootedDynamic;
    }

    public Property property() throws PropertyParseNodepException {
        Property first = this.eventPropertyAtomic();
        if (this.lookahead.token == TokenType.END) {
            return first;
        }
        ArrayList<Property> props = new ArrayList<Property>(4);
        props.add(first);
        while (this.lookahead.token == TokenType.DOT) {
            this.nextToken();
            Property next = this.eventPropertyAtomic();
            props.add(next);
        }
        return new NestedProperty(props);
    }

    private Property eventPropertyAtomic() {
        if (this.lookahead.token != TokenType.IDENT && this.lookahead.token != TokenType.IDENTESCAPED) {
            this.expectOrFail(TokenType.IDENT);
        }
        String ident = this.lookahead.token == TokenType.IDENT ? this.processIdent(this.lookahead.sequence) : this.processIdent(PropertyParser.unescapeBacktickForProperty(this.lookahead.sequence));
        this.nextToken();
        if (this.lookahead.token == TokenType.LBRACK) {
            this.nextToken();
            this.expectOrFail(TokenType.LBRACK, TokenType.NUMBER);
            int index = Integer.parseInt(this.lookahead.sequence);
            this.nextToken();
            this.expectOrFail(TokenType.NUMBER, TokenType.RBRACK);
            this.nextToken();
            if (this.lookahead.token == TokenType.QUESTION) {
                this.nextToken();
                return new DynamicIndexedProperty(ident, index);
            }
            if (this.dynamic) {
                return new DynamicIndexedProperty(ident, index);
            }
            return new IndexedProperty(ident, index);
        }
        if (this.lookahead.token == TokenType.LPAREN) {
            this.nextToken();
            if (this.lookahead.token == TokenType.DOUBLEQUOTEDLITERAL || this.lookahead.token == TokenType.SINGLEQUOTEDLITERAL) {
                TokenType type = this.lookahead.token;
                String value = this.lookahead.sequence.trim();
                String key = value.substring(1, value.length() - 1);
                this.nextToken();
                this.expectOrFail(type, TokenType.RPAREN);
                this.nextToken();
                if (this.lookahead.token == TokenType.QUESTION) {
                    this.nextToken();
                    return new DynamicMappedProperty(ident, key);
                }
                if (this.dynamic) {
                    return new DynamicMappedProperty(ident, key);
                }
                return new MappedProperty(ident, key);
            }
            this.expectOrFail(TokenType.LPAREN, TokenType.DOUBLEQUOTEDLITERAL);
        }
        if (this.lookahead.token == TokenType.QUESTION) {
            this.nextToken();
            this.dynamic = true;
            return new DynamicSimpleProperty(ident);
        }
        if (this.dynamic) {
            return new DynamicSimpleProperty(ident);
        }
        return new SimpleProperty(ident);
    }

    private String processIdent(String ident) {
        if (!ident.contains(".")) {
            return ident;
        }
        return ident.replaceAll("\\\\.", ".");
    }

    private void expectOrFail(TokenType before, TokenType expected) {
        if (this.lookahead.token != expected) {
            throw new PropertyParseNodepException("Unexpected token " + this.lookahead.token + " value '" + this.lookahead.sequence + "', expecting " + expected + " after " + before);
        }
    }

    private void expectOrFail(TokenType expected) {
        if (this.lookahead.token != expected) {
            throw new PropertyParseNodepException("Unexpected token " + this.lookahead.token + " value '" + this.lookahead.sequence + "', expecting " + expected);
        }
    }

    private void nextToken() {
        this.tokens.pop();
        this.lookahead = this.tokens.isEmpty() ? new Token(TokenType.END, "") : this.tokens.getFirst();
    }
}

