/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.render;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.render.EventPropertyRenderer;
import com.espertech.esper.common.client.render.EventPropertyRendererContext;
import com.espertech.esper.common.client.render.XMLEventRenderer;
import com.espertech.esper.common.client.render.XMLRenderingOptions;
import com.espertech.esper.common.internal.event.render.GetterPair;
import com.espertech.esper.common.internal.event.render.NestedGetterPair;
import com.espertech.esper.common.internal.event.render.OutputValueRenderer;
import com.espertech.esper.common.internal.event.render.OutputValueRendererFactory;
import com.espertech.esper.common.internal.event.render.RendererMeta;
import com.espertech.esper.common.internal.event.render.RendererMetaOptions;
import com.espertech.esper.common.internal.event.util.EventTypePropertyPair;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLRendererImpl
implements XMLEventRenderer {
    private static final Logger log = LoggerFactory.getLogger(XMLRendererImpl.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private final RendererMeta meta;
    private final XMLRenderingOptions options;
    private final RendererMetaOptions rendererMetaOptions;

    public XMLRendererImpl(EventType eventType, XMLRenderingOptions options) {
        EventPropertyRenderer propertyRenderer = null;
        EventPropertyRendererContext propertyRendererContext = null;
        if (options.getRenderer() != null) {
            propertyRenderer = options.getRenderer();
            propertyRendererContext = new EventPropertyRendererContext(eventType, false);
        }
        this.rendererMetaOptions = new RendererMetaOptions(options.isPreventLooping(), true, propertyRenderer, propertyRendererContext);
        this.meta = new RendererMeta(eventType, new Stack<EventTypePropertyPair>(), this.rendererMetaOptions);
        this.options = options;
    }

    @Override
    public String render(String rootElementName, EventBean theEvent) {
        if (this.options.isDefaultAsAttribute()) {
            return this.renderAttributeXML(rootElementName, theEvent);
        }
        return this.renderElementXML(rootElementName, theEvent);
    }

    private String renderElementXML(String rootElementName, EventBean theEvent) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append(NEWLINE);
        buf.append('<');
        buf.append(rootElementName);
        buf.append('>');
        buf.append(NEWLINE);
        XMLRendererImpl.recursiveRender(theEvent, buf, 1, this.meta, this.rendererMetaOptions);
        buf.append("</");
        buf.append(this.getFirstWord(rootElementName));
        buf.append('>');
        return buf.toString();
    }

    private String renderAttributeXML(String rootElementName, EventBean theEvent) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append(NEWLINE);
        buf.append('<');
        buf.append(rootElementName);
        this.renderAttributes(theEvent, buf, this.meta);
        String inner = this.renderAttElements(theEvent, 1, this.meta);
        if (inner == null || inner.trim().length() == 0) {
            buf.append("/>");
            buf.append(NEWLINE);
        } else {
            buf.append(">");
            buf.append(NEWLINE);
            buf.append(inner);
            buf.append("</");
            buf.append(this.getFirstWord(rootElementName));
            buf.append('>');
        }
        return buf.toString();
    }

    private String renderAttElements(EventBean theEvent, int level, RendererMeta meta) {
        NestedGetterPair[] nestedProps;
        GetterPair[] mappedProps;
        GetterPair[] indexProps;
        StringBuilder buf = new StringBuilder();
        for (GetterPair indexProp : indexProps = meta.getIndexProperties()) {
            Object value = indexProp.getGetter().get(theEvent);
            if (value == null) continue;
            if (!value.getClass().isArray()) {
                log.warn("Property '" + indexProp.getName() + "' returned a non-array object");
                continue;
            }
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object arrayItem = Array.get(value, i);
                if (arrayItem == null) continue;
                XMLRendererImpl.ident(buf, level);
                buf.append('<');
                buf.append(indexProp.getName());
                buf.append('>');
                if (this.rendererMetaOptions.getRenderer() == null) {
                    indexProp.getOutput().render(arrayItem, buf);
                } else {
                    EventPropertyRendererContext context = this.rendererMetaOptions.getRendererContext();
                    context.setStringBuilderAndReset(buf);
                    context.setPropertyName(indexProp.getName());
                    context.setPropertyValue(arrayItem);
                    context.setIndexedPropertyIndex(i);
                    context.setDefaultRenderer(indexProp.getOutput());
                    this.rendererMetaOptions.getRenderer().render(context);
                }
                buf.append("</");
                buf.append(indexProp.getName());
                buf.append('>');
                buf.append(NEWLINE);
            }
        }
        for (GetterPair mappedProp : mappedProps = meta.getMappedProperties()) {
            Map map;
            Object value = mappedProp.getGetter().get(theEvent);
            if (value != null && !(value instanceof Map)) {
                log.warn("Property '" + mappedProp.getName() + "' expected to return Map and returned " + value.getClass() + " instead");
                continue;
            }
            XMLRendererImpl.ident(buf, level);
            buf.append('<');
            buf.append(mappedProp.getName());
            if (value != null && !(map = (Map)value).isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    buf.append(" ");
                    buf.append((String)entry.getKey());
                    buf.append("=\"");
                    OutputValueRenderer outputValueRenderer = OutputValueRendererFactory.getOutputValueRenderer(entry.getValue().getClass(), this.rendererMetaOptions);
                    if (this.rendererMetaOptions.getRenderer() == null) {
                        outputValueRenderer.render(entry.getValue(), buf);
                    } else {
                        EventPropertyRendererContext context = this.rendererMetaOptions.getRendererContext();
                        context.setStringBuilderAndReset(buf);
                        context.setPropertyName(mappedProp.getName());
                        context.setPropertyValue(entry.getValue());
                        context.setMappedPropertyKey((String)entry.getKey());
                        context.setDefaultRenderer(outputValueRenderer);
                        this.rendererMetaOptions.getRenderer().render(context);
                    }
                    buf.append("\"");
                }
            }
            buf.append("/>");
            buf.append(NEWLINE);
        }
        for (NestedGetterPair nestedProp : nestedProps = meta.getNestedProperties()) {
            Object value = nestedProp.getGetter().getFragment(theEvent);
            if (value == null) continue;
            if (!nestedProp.isArray()) {
                if (!(value instanceof EventBean)) {
                    log.warn("Property '" + nestedProp.getName() + "' expected to return EventBean and returned " + value.getClass() + " instead");
                    buf.append("null");
                    continue;
                }
                EventBean nestedEventBean = (EventBean)value;
                this.renderAttInner(buf, level, nestedEventBean, nestedProp);
                continue;
            }
            if (!(value instanceof EventBean[])) {
                log.warn("Property '" + nestedProp.getName() + "' expected to return EventBean[] and returned " + value.getClass() + " instead");
                buf.append("null");
                continue;
            }
            EventBean[] nestedEventArray = (EventBean[])value;
            for (int i = 0; i < nestedEventArray.length; ++i) {
                EventBean arrayItem = nestedEventArray[i];
                this.renderAttInner(buf, level, arrayItem, nestedProp);
            }
        }
        return buf.toString();
    }

    private void renderAttributes(EventBean theEvent, StringBuilder buf, RendererMeta meta) {
        GetterPair[] simpleProps;
        String delimiter = " ";
        for (GetterPair simpleProp : simpleProps = meta.getSimpleProperties()) {
            Object value = simpleProp.getGetter().get(theEvent);
            if (value == null) continue;
            buf.append(delimiter);
            buf.append(simpleProp.getName());
            buf.append("=\"");
            if (this.rendererMetaOptions.getRenderer() == null) {
                simpleProp.getOutput().render(value, buf);
            } else {
                EventPropertyRendererContext context = this.rendererMetaOptions.getRendererContext();
                context.setStringBuilderAndReset(buf);
                context.setPropertyName(simpleProp.getName());
                context.setPropertyValue(value);
                context.setDefaultRenderer(simpleProp.getOutput());
                this.rendererMetaOptions.getRenderer().render(context);
            }
            buf.append('\"');
        }
    }

    private static void ident(StringBuilder buf, int level) {
        for (int i = 0; i < level; ++i) {
            XMLRendererImpl.indentChar(buf);
        }
    }

    private static void indentChar(StringBuilder buf) {
        buf.append(' ');
        buf.append(' ');
    }

    private static void recursiveRender(EventBean theEvent, StringBuilder buf, int level, RendererMeta meta, RendererMetaOptions rendererMetaOptions) {
        NestedGetterPair[] nestedProps;
        GetterPair[] mappedProps;
        GetterPair[] indexProps;
        GetterPair[] simpleProps;
        for (GetterPair simpleProp : simpleProps = meta.getSimpleProperties()) {
            Object value = simpleProp.getGetter().get(theEvent);
            if (value == null) continue;
            XMLRendererImpl.ident(buf, level);
            buf.append('<');
            buf.append(simpleProp.getName());
            buf.append('>');
            if (rendererMetaOptions.getRenderer() == null) {
                simpleProp.getOutput().render(value, buf);
            } else {
                EventPropertyRendererContext context = rendererMetaOptions.getRendererContext();
                context.setStringBuilderAndReset(buf);
                context.setPropertyName(simpleProp.getName());
                context.setPropertyValue(value);
                context.setDefaultRenderer(simpleProp.getOutput());
                rendererMetaOptions.getRenderer().render(context);
            }
            buf.append("</");
            buf.append(simpleProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
        }
        for (GetterPair indexProp : indexProps = meta.getIndexProperties()) {
            Object value = indexProp.getGetter().get(theEvent);
            if (value == null) continue;
            if (!value.getClass().isArray()) {
                log.warn("Property '" + indexProp.getName() + "' returned a non-array object");
                continue;
            }
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object arrayItem = Array.get(value, i);
                if (arrayItem == null) continue;
                XMLRendererImpl.ident(buf, level);
                buf.append('<');
                buf.append(indexProp.getName());
                buf.append('>');
                if (rendererMetaOptions.getRenderer() == null) {
                    indexProp.getOutput().render(arrayItem, buf);
                } else {
                    EventPropertyRendererContext context = rendererMetaOptions.getRendererContext();
                    context.setStringBuilderAndReset(buf);
                    context.setPropertyName(indexProp.getName());
                    context.setPropertyValue(arrayItem);
                    context.setIndexedPropertyIndex(i);
                    context.setDefaultRenderer(indexProp.getOutput());
                    rendererMetaOptions.getRenderer().render(context);
                }
                buf.append("</");
                buf.append(indexProp.getName());
                buf.append('>');
                buf.append(NEWLINE);
            }
        }
        for (GetterPair mappedProp : mappedProps = meta.getMappedProperties()) {
            Map map;
            Object value = mappedProp.getGetter().get(theEvent);
            if (value != null && !(value instanceof Map)) {
                log.warn("Property '" + mappedProp.getName() + "' expected to return Map and returned " + value.getClass() + " instead");
                continue;
            }
            XMLRendererImpl.ident(buf, level);
            buf.append('<');
            buf.append(mappedProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
            if (value != null && !(map = (Map)value).isEmpty()) {
                String localDelimiter = "";
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null) continue;
                    buf.append(localDelimiter);
                    XMLRendererImpl.ident(buf, level + 1);
                    buf.append('<');
                    buf.append((String)entry.getKey());
                    buf.append('>');
                    if (entry.getValue() != null) {
                        OutputValueRenderer outputValueRenderer = OutputValueRendererFactory.getOutputValueRenderer(entry.getValue().getClass(), rendererMetaOptions);
                        if (rendererMetaOptions.getRenderer() == null) {
                            outputValueRenderer.render(entry.getValue(), buf);
                        } else {
                            EventPropertyRendererContext context = rendererMetaOptions.getRendererContext();
                            context.setStringBuilderAndReset(buf);
                            context.setPropertyName(mappedProp.getName());
                            context.setPropertyValue(entry.getValue());
                            context.setMappedPropertyKey((String)entry.getKey());
                            context.setDefaultRenderer(outputValueRenderer);
                            rendererMetaOptions.getRenderer().render(context);
                        }
                    }
                    buf.append("</");
                    buf.append((String)entry.getKey());
                    buf.append('>');
                    localDelimiter = NEWLINE;
                }
            }
            buf.append(NEWLINE);
            XMLRendererImpl.ident(buf, level);
            buf.append("</");
            buf.append(mappedProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
        }
        for (NestedGetterPair nestedProp : nestedProps = meta.getNestedProperties()) {
            Object value = nestedProp.getGetter().getFragment(theEvent);
            if (value == null) continue;
            if (!nestedProp.isArray()) {
                if (!(value instanceof EventBean)) {
                    log.warn("Property '" + nestedProp.getName() + "' expected to return EventBean and returned " + value.getClass() + " instead");
                    buf.append("null");
                    continue;
                }
                XMLRendererImpl.renderElementFragment((EventBean)value, buf, level, nestedProp, rendererMetaOptions);
                continue;
            }
            if (!(value instanceof EventBean[])) {
                log.warn("Property '" + nestedProp.getName() + "' expected to return EventBean[] and returned " + value.getClass() + " instead");
                buf.append("null");
                continue;
            }
            EventBean[] nestedEventArray = (EventBean[])value;
            for (int i = 0; i < nestedEventArray.length; ++i) {
                EventBean arrayItem = nestedEventArray[i];
                if (arrayItem == null) continue;
                XMLRendererImpl.renderElementFragment(arrayItem, buf, level, nestedProp, rendererMetaOptions);
            }
        }
    }

    private static void renderElementFragment(EventBean eventBean, StringBuilder buf, int level, NestedGetterPair nestedProp, RendererMetaOptions rendererMetaOptions) {
        XMLRendererImpl.ident(buf, level);
        buf.append('<');
        buf.append(nestedProp.getName());
        buf.append('>');
        buf.append(NEWLINE);
        XMLRendererImpl.recursiveRender(eventBean, buf, level + 1, nestedProp.getMetadata(), rendererMetaOptions);
        XMLRendererImpl.ident(buf, level);
        buf.append("</");
        buf.append(nestedProp.getName());
        buf.append('>');
        buf.append(NEWLINE);
    }

    private void renderAttInner(StringBuilder buf, int level, EventBean nestedEventBean, NestedGetterPair nestedProp) {
        XMLRendererImpl.ident(buf, level);
        buf.append('<');
        buf.append(nestedProp.getName());
        this.renderAttributes(nestedEventBean, buf, nestedProp.getMetadata());
        String inner = this.renderAttElements(nestedEventBean, level + 1, nestedProp.getMetadata());
        if (inner == null || inner.trim().length() == 0) {
            buf.append("/>");
            buf.append(NEWLINE);
        } else {
            buf.append(">");
            buf.append(NEWLINE);
            buf.append(inner);
            XMLRendererImpl.ident(buf, level);
            buf.append("</");
            buf.append(nestedProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
        }
    }

    private String getFirstWord(String rootElementName) {
        if (rootElementName == null || rootElementName.trim().length() == 0) {
            return rootElementName;
        }
        int index = rootElementName.indexOf(32);
        if (index < 0) {
            return rootElementName;
        }
        return rootElementName.substring(0, index);
    }
}

