/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.util;

import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyUtility {
    public static PropertyAccessException getIllegalAccessException(Field field, IllegalAccessException e) {
        return PropertyUtility.getAccessExceptionField(field, e);
    }

    public static PropertyAccessException getIllegalArgumentException(Field field, IllegalArgumentException e) {
        return PropertyUtility.getAccessExceptionField(field, e);
    }

    private static PropertyAccessException getAccessExceptionField(Field field, Exception e) {
        Class<?> declaring = field.getDeclaringClass();
        String message = "Failed to obtain field value for field " + field.getName() + " on class " + ClassHelperPrint.getClassNameFullyQualPretty(declaring) + ": " + e.getMessage();
        throw new PropertyAccessException(message, e);
    }

    private static PropertyAccessException getMismatchException(Class declared, Object object, ClassCastException e) {
        String classNameReceived;
        String classNameExpected = ClassHelperPrint.getClassNameFullyQualPretty(declared);
        if (classNameExpected.equals(classNameReceived = object != null ? ClassHelperPrint.getClassNameFullyQualPretty(object.getClass()) : "null")) {
            classNameExpected = ClassHelperPrint.getClassNameFullyQualPrettyWithClassloader(declared);
            classNameReceived = object != null ? ClassHelperPrint.getClassNameFullyQualPrettyWithClassloader(object.getClass()) : "null";
        }
        String message = "Mismatched getter instance to event bean type, expected " + classNameExpected + " but received " + classNameReceived;
        throw new PropertyAccessException(message, e);
    }

    public static PropertyAccessException getIllegalAccessException(Method method, IllegalAccessException e) {
        return PropertyUtility.getAccessExceptionMethod(method, e);
    }

    public static PropertyAccessException getIllegalArgumentException(Method method, IllegalArgumentException e) {
        return PropertyUtility.getAccessExceptionMethod(method, e);
    }

    private static PropertyAccessException getAccessExceptionMethod(Method method, Exception e) {
        Class<?> declaring = method.getDeclaringClass();
        String message = "Failed to invoke method " + method.getName() + " on class " + ClassHelperPrint.getClassNameFullyQualPretty(declaring) + ": " + e.getMessage();
        throw new PropertyAccessException(message, e);
    }

    public static PropertyAccessException getMismatchException(Method method, Object object, ClassCastException e) {
        return PropertyUtility.getMismatchException(method.getDeclaringClass(), object, e);
    }

    public static PropertyAccessException getMismatchException(Field field, Object object, ClassCastException e) {
        return PropertyUtility.getMismatchException(field.getDeclaringClass(), object, e);
    }

    public static PropertyAccessException getInvocationTargetException(Method method, InvocationTargetException e) {
        Class<?> declaring = method.getDeclaringClass();
        String message = "Failed to invoke method " + method.getName() + " on class " + ClassHelperPrint.getClassNameFullyQualPretty(declaring) + ": " + e.getTargetException().getMessage();
        throw new PropertyAccessException(message, e);
    }

    public static PropertyAccessException getGeneralException(Method method, Throwable t) {
        Class<?> declaring = method.getDeclaringClass();
        String message = "Failed to invoke method " + method.getName() + " on class " + ClassHelperPrint.getClassNameFullyQualPretty(declaring) + ": " + t.getMessage();
        throw new PropertyAccessException(message, t);
    }

    public static PropertyAccessException getGeneralException(Field field, Throwable t) {
        Class<?> declaring = field.getDeclaringClass();
        String message = "Failed to obtain field value for field " + field.getName() + " on class " + ClassHelperPrint.getClassNameFullyQualPretty(declaring) + ": " + t.getMessage();
        throw new PropertyAccessException(message, t);
    }
}

