/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.variant;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventPropertyGetterIndexed;
import com.espertech.esper.common.client.EventPropertyGetterMapped;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariantStream;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterIndexedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterMappedSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.variant.VariantEventBean;
import com.espertech.esper.common.internal.event.variant.VariantEventTypeUtil;
import com.espertech.esper.common.internal.event.variant.VariantPropResolutionStrategy;
import com.espertech.esper.common.internal.event.variant.VariantPropResolutionStrategyAny;
import com.espertech.esper.common.internal.event.variant.VariantPropResolutionStrategyDefault;
import com.espertech.esper.common.internal.event.variant.VariantPropertyDesc;
import com.espertech.esper.common.internal.event.variant.VariantPropertyGetterCache;
import com.espertech.esper.common.internal.event.variant.VariantSpec;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VariantEventType
implements EventTypeSPI {
    public static final EPTypeClass EPTYPE = new EPTypeClass(VariantEventType.class);
    private EventTypeMetadata metadata;
    private final EventType[] variants;
    private final boolean variantAny;
    private final VariantPropResolutionStrategy propertyResStrategy;
    private final Map<String, VariantPropertyDesc> propertyDesc;
    private final String[] propertyNames;
    private final EventPropertyDescriptor[] propertyDescriptors;
    private final Map<String, EventPropertyDescriptor> propertyDescriptorMap;
    private final VariantPropertyGetterCache variantPropertyGetterCache;
    private Map<String, EventPropertyGetter> propertyGetterCodegeneratedCache;

    public VariantEventType(EventTypeMetadata metadata, VariantSpec variantSpec) {
        this.metadata = metadata;
        this.variants = variantSpec.getEventTypes();
        this.variantAny = variantSpec.getTypeVariance() == ConfigurationCommonVariantStream.TypeVariance.ANY;
        this.variantPropertyGetterCache = new VariantPropertyGetterCache(variantSpec.getEventTypes());
        this.propertyResStrategy = this.variantAny ? new VariantPropResolutionStrategyAny(this) : new VariantPropResolutionStrategyDefault(this);
        this.propertyDesc = new HashMap<String, VariantPropertyDesc>();
        for (EventType type : this.variants) {
            String[] properties = type.getPropertyNames();
            for (String property : properties = CollectionUtil.copyAndSort(properties)) {
                if (this.propertyDesc.containsKey(property)) continue;
                this.findProperty(property);
            }
        }
        Set<String> propertyNameKeySet = this.propertyDesc.keySet();
        this.propertyNames = propertyNameKeySet.toArray(new String[propertyNameKeySet.size()]);
        this.propertyDescriptors = new EventPropertyDescriptor[this.propertyDesc.size()];
        this.propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        int count = 0;
        for (Map.Entry<String, VariantPropertyDesc> desc : this.propertyDesc.entrySet()) {
            EPType type = desc.getValue().getPropertyType();
            EventPropertyDescriptor descriptor = new EventPropertyDescriptor(desc.getKey(), type, false, false, false, false, JavaClassHelper.isFragmentableType(type));
            this.propertyDescriptors[count++] = descriptor;
            this.propertyDescriptorMap.put(desc.getKey(), descriptor);
        }
    }

    @Override
    public String getStartTimestampPropertyName() {
        return null;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return null;
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        return EventTypeUtility.getPropertyTypeAsClass(this.getPropertyEPType(propertyName));
    }

    @Override
    public EPType getPropertyEPType(String property) {
        VariantPropertyDesc entry = this.propertyDesc.get(property);
        if (entry != null) {
            return entry.getPropertyType();
        }
        entry = this.findProperty(property);
        if (entry != null) {
            return entry.getPropertyType();
        }
        return null;
    }

    public EventType[] getVariants() {
        return this.variants;
    }

    @Override
    public Class getUnderlyingType() {
        return Object.class;
    }

    @Override
    public EPTypeClass getUnderlyingEPType() {
        return EPTypePremade.OBJECT.getEPType();
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public EventPropertyGetterSPI getGetterSPI(String property) {
        VariantPropertyDesc entry = this.propertyDesc.get(property);
        if (entry != null) {
            return entry.getGetter();
        }
        entry = this.findProperty(property);
        if (entry != null) {
            return entry.getGetter();
        }
        return null;
    }

    public VariantPropertyGetterCache getVariantPropertyGetterCache() {
        return this.variantPropertyGetterCache;
    }

    @Override
    public EventPropertyGetter getGetter(String propertyName) {
        EventPropertyGetter getter;
        if (this.propertyGetterCodegeneratedCache == null) {
            this.propertyGetterCodegeneratedCache = new HashMap<String, EventPropertyGetter>();
        }
        if ((getter = this.propertyGetterCodegeneratedCache.get(propertyName)) != null) {
            return getter;
        }
        EventPropertyGetterSPI getterSPI = this.getGetterSPI(propertyName);
        if (getterSPI == null) {
            return null;
        }
        this.propertyGetterCodegeneratedCache.put(propertyName, getterSPI);
        return getterSPI;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String property) {
        VariantPropertyDesc entry = this.propertyDesc.get(property);
        if (entry != null) {
            return entry.isProperty();
        }
        entry = this.findProperty(property);
        if (entry != null) {
            return entry.isProperty();
        }
        return false;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    private VariantPropertyDesc findProperty(String propertyName) {
        VariantPropertyDesc desc = this.propertyResStrategy.resolveProperty(propertyName, this.variants);
        if (desc != null) {
            this.propertyDesc.put(propertyName, desc);
        }
        return desc;
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public FragmentEventType getFragmentType(String property) {
        return null;
    }

    @Override
    public EventPropertyWriterSPI getWriter(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        return new EventPropertyDescriptor[0];
    }

    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        return null;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        return null;
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedProperty) {
        return null;
    }

    @Override
    public EventPropertyGetterMappedSPI getGetterMappedSPI(String mappedProperty) {
        return null;
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedProperty) {
        return null;
    }

    @Override
    public EventPropertyGetterIndexedSPI getGetterIndexedSPI(String propertyName) {
        return null;
    }

    @Override
    public ExprValidationException equalsCompareType(EventType eventType) {
        return this == eventType ? null : new ExprValidationException("Variant types mismatch");
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        return null;
    }

    @Override
    public void setMetadataId(long publicId, long protectedId) {
        this.metadata = this.metadata.withIds(publicId, protectedId);
    }

    @Override
    public Set<EventType> getDeepSuperTypesAsSet() {
        return Collections.emptySet();
    }

    public boolean isVariantAny() {
        return this.variantAny;
    }

    public void validateInsertedIntoEventType(EventType eventType) throws ExprValidationException {
        VariantEventTypeUtil.validateInsertedIntoEventType(eventType, this);
    }

    public EventBean getValueAddEventBean(EventBean theEvent) {
        return new VariantEventBean(this, theEvent);
    }

    public EventType eventTypeForNativeObject(Object event) {
        if (event == null) {
            throw new EPException("Null event object returned");
        }
        for (EventType variant : this.variants) {
            if (!(variant instanceof BeanEventType)) continue;
            BeanEventType beanEventType = (BeanEventType)variant;
            if (!JavaClassHelper.isSubclassOrImplementsInterface(event.getClass(), beanEventType.getUnderlyingType())) continue;
            return variant;
        }
        throw new EPException("Failed to determine event type for event object of type '" + event.getClass() + "' for use with variant stream '" + this.getName() + "'");
    }
}

