/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.variant;

import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariantPropertyGetterCache {
    public static final EPTypeClass EPTYPE = new EPTypeClass(VariantPropertyGetterCache.class);
    private volatile EventType[] knownTypes;
    private volatile VariantPropertyGetterRow lastUsedGetters;
    private List<String> properties;
    private Map<EventType, VariantPropertyGetterRow> allGetters;

    public VariantPropertyGetterCache(EventType[] knownTypes) {
        this.knownTypes = knownTypes;
        this.allGetters = new HashMap<EventType, VariantPropertyGetterRow>();
        this.properties = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGetters(String propertyName) {
        for (EventType type : this.knownTypes) {
            EventPropertyGetter getter = type.getGetter(propertyName);
            VariantPropertyGetterRow row = this.allGetters.get(type);
            if (row == null) {
                VariantPropertyGetterCache variantPropertyGetterCache = this;
                synchronized (variantPropertyGetterCache) {
                    row = new VariantPropertyGetterRow(type, new HashMap<String, EventPropertyGetter>());
                    this.allGetters.put(type, row);
                }
            }
            row.addGetter(propertyName, getter);
        }
        this.properties.add(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPropertyGetter getGetter(String propertyName, EventType eventType) {
        VariantPropertyGetterRow lastGetters = this.lastUsedGetters;
        if (lastGetters != null && lastGetters.eventType == eventType) {
            EventPropertyGetter getter = lastGetters.getGetterPerProp().get(propertyName);
            if (getter == null) {
                getter = eventType.getGetter(propertyName);
                lastGetters.addGetter(propertyName, getter);
            }
            return getter;
        }
        VariantPropertyGetterRow row = this.allGetters.get(eventType);
        if (row == null) {
            VariantPropertyGetterCache variantPropertyGetterCache = this;
            synchronized (variantPropertyGetterCache) {
                row = this.allGetters.get(eventType);
                if (row == null) {
                    row = this.addType(eventType);
                }
            }
        }
        EventPropertyGetter getter = row.getGetterPerProp().get(propertyName);
        this.lastUsedGetters = row;
        if (getter == null) {
            getter = eventType.getGetter(propertyName);
            row.addGetter(propertyName, getter);
        }
        return getter;
    }

    private VariantPropertyGetterRow addType(EventType eventType) {
        EventType[] newKnownTypes = (EventType[])VariantPropertyGetterCache.resizeArray(this.knownTypes, this.knownTypes.length + 1);
        newKnownTypes[newKnownTypes.length - 1] = eventType;
        HashMap<String, EventPropertyGetter> getters = new HashMap<String, EventPropertyGetter>(CollectionUtil.capacityHashMap(this.properties.size()));
        for (int i = 0; i < this.properties.size(); ++i) {
            String propertyName = this.properties.get(i);
            EventPropertyGetter getter = eventType.getGetter(propertyName);
            getters.put(propertyName, getter);
        }
        VariantPropertyGetterRow row = new VariantPropertyGetterRow(eventType, getters);
        HashMap<EventType, VariantPropertyGetterRow> newAllGetters = new HashMap<EventType, VariantPropertyGetterRow>();
        newAllGetters.putAll(this.allGetters);
        newAllGetters.put(eventType, row);
        this.knownTypes = newKnownTypes;
        this.allGetters = newAllGetters;
        return row;
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static class VariantPropertyGetterRow {
        private final EventType eventType;
        private final Map<String, EventPropertyGetter> getterPerProp;

        private VariantPropertyGetterRow(EventType eventType, Map<String, EventPropertyGetter> getterPerProp) {
            this.eventType = eventType;
            this.getterPerProp = getterPerProp;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public Map<String, EventPropertyGetter> getGetterPerProp() {
            return this.getterPerProp;
        }

        public void addGetter(String propertyName, EventPropertyGetter getter) {
            this.getterPerProp.put(propertyName, getter);
        }
    }
}

