/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeXMLDOM;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.ClassForNameProviderDefault;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.BaseConfigurableEventType;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventPropertyWriterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.ExplicitPropertyDescriptor;
import com.espertech.esper.common.internal.event.xml.FragmentFactoryXPathPredefinedGetter;
import com.espertech.esper.common.internal.event.xml.SchemaUtil;
import com.espertech.esper.common.internal.event.xml.XMLFragmentEventTypeFactory;
import com.espertech.esper.common.internal.event.xml.XPathNamespaceContext;
import com.espertech.esper.common.internal.event.xml.XPathPropertyGetter;
import com.espertech.esper.common.internal.util.ClassInstantiationException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseXMLEventType
extends BaseConfigurableEventType {
    public static final EPTypeClass EPTYPE = new EPTypeClass(BaseXMLEventType.class);
    private static final Logger log = LoggerFactory.getLogger(BaseXMLEventType.class);
    private final XPathFactory xPathFactory;
    private final String rootElementName;
    private final ConfigurationCommonEventTypeXMLDOM configurationEventTypeXMLDOM;
    private String startTimestampPropertyName;
    private String endTimestampPropertyName;
    protected XPathNamespaceContext namespaceContext;

    public BaseXMLEventType(EventTypeMetadata metadata, ConfigurationCommonEventTypeXMLDOM configurationEventTypeXMLDOM, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeNameResolver eventTypeResolver, XMLFragmentEventTypeFactory xmlEventTypeFactory) {
        super(eventBeanTypedEventFactory, metadata, EPTypePremade.NODE.getEPType(), eventTypeResolver, xmlEventTypeFactory);
        this.rootElementName = configurationEventTypeXMLDOM.getRootElementName();
        this.configurationEventTypeXMLDOM = configurationEventTypeXMLDOM;
        this.xPathFactory = XPathFactory.newInstance();
        if (configurationEventTypeXMLDOM.getXPathFunctionResolver() != null) {
            try {
                XPathFunctionResolver fresolver = JavaClassHelper.instantiate(XPathFunctionResolver.class, configurationEventTypeXMLDOM.getXPathFunctionResolver(), ClassForNameProviderDefault.INSTANCE);
                this.xPathFactory.setXPathFunctionResolver(fresolver);
            }
            catch (ClassInstantiationException ex) {
                throw new ConfigurationException("Error configuring XPath function resolver for XML type '" + configurationEventTypeXMLDOM.getRootElementName() + "' : " + ex.getMessage(), ex);
            }
        }
        if (configurationEventTypeXMLDOM.getXPathVariableResolver() != null) {
            try {
                XPathVariableResolver vresolver = JavaClassHelper.instantiate(XPathVariableResolver.class, configurationEventTypeXMLDOM.getXPathVariableResolver(), ClassForNameProviderDefault.INSTANCE);
                this.xPathFactory.setXPathVariableResolver(vresolver);
            }
            catch (ClassInstantiationException ex) {
                throw new ConfigurationException("Error configuring XPath variable resolver for XML type '" + configurationEventTypeXMLDOM.getRootElementName() + "' : " + ex.getMessage(), ex);
            }
        }
    }

    public void setUnderlyingBindingDIO(DataInputOutputSerde underlyingSerde) {
        throw new UnsupportedOperationException("XML event type does not receive a serde");
    }

    public DataInputOutputSerde getUnderlyingBindingDIO() {
        return null;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    protected void setNamespaceContext(XPathNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    protected void initialize(Collection<ConfigurationCommonEventTypeXMLDOM.XPathPropertyDesc> explicitXPathProperties, List<ExplicitPropertyDescriptor> additionalSchemaProperties) {
        LinkedHashMap<String, ExplicitPropertyDescriptor> namedProperties = new LinkedHashMap<String, ExplicitPropertyDescriptor>();
        for (ExplicitPropertyDescriptor explicitPropertyDescriptor : additionalSchemaProperties) {
            namedProperties.put(explicitPropertyDescriptor.getDescriptor().getPropertyName(), explicitPropertyDescriptor);
        }
        String xpathExpression = null;
        try {
            for (ConfigurationCommonEventTypeXMLDOM.XPathPropertyDesc property : explicitXPathProperties) {
                XPath xPath = this.xPathFactory.newXPath();
                if (this.namespaceContext != null) {
                    xPath.setNamespaceContext(this.namespaceContext);
                }
                xpathExpression = property.getXpath();
                if (log.isDebugEnabled()) {
                    log.debug("Compiling XPath expression for property '" + property.getName() + "' as '" + xpathExpression + "'");
                }
                XPathExpression expression = xPath.compile(xpathExpression);
                FragmentFactoryXPathPredefinedGetter fragmentFactory = null;
                boolean isFragment = false;
                if (property.getOptionaleventTypeName() != null) {
                    fragmentFactory = new FragmentFactoryXPathPredefinedGetter(this.getEventBeanTypedEventFactory(), this.getEventTypeResolver(), property.getOptionaleventTypeName(), property.getName());
                    isFragment = true;
                }
                boolean isArray = false;
                if (property.getType().equals(XPathConstants.NODESET)) {
                    isArray = true;
                }
                XPathPropertyGetter getter = new XPathPropertyGetter(this, property.getName(), xpathExpression, expression, property.getType(), property.getOptionalCastToType(), fragmentFactory);
                EPTypeClass returnType = SchemaUtil.toReturnType(property.getType(), property.getOptionalCastToType());
                EventPropertyDescriptor desc = new EventPropertyDescriptor(property.getName(), returnType, false, false, isArray, false, isFragment);
                ExplicitPropertyDescriptor explicit = new ExplicitPropertyDescriptor(desc, getter, isArray, property.getOptionaleventTypeName());
                namedProperties.put(desc.getPropertyName(), explicit);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new EPException("XPath expression could not be compiled for expression '" + xpathExpression + "'", xPathExpressionException);
        }
        super.initialize(new ArrayList<ExplicitPropertyDescriptor>(namedProperties.values()));
        this.startTimestampPropertyName = this.configurationEventTypeXMLDOM.getStartTimestampPropertyName();
        this.endTimestampPropertyName = this.configurationEventTypeXMLDOM.getEndTimestampPropertyName();
        EventTypeUtility.validateTimestampProperties(this, this.startTimestampPropertyName, this.endTimestampPropertyName);
    }

    protected XPathFactory getXPathFactory() {
        return this.xPathFactory;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    @Override
    public Set<EventType> getDeepSuperTypesAsSet() {
        return Collections.emptySet();
    }

    public ConfigurationCommonEventTypeXMLDOM getConfigurationEventTypeXMLDOM() {
        return this.configurationEventTypeXMLDOM;
    }

    @Override
    public ExprValidationException equalsCompareType(EventType eventType) {
        if (!(eventType instanceof BaseXMLEventType)) {
            return new ExprValidationException("Expected a base-xml event type but received " + eventType);
        }
        BaseXMLEventType other = (BaseXMLEventType)eventType;
        if (!this.configurationEventTypeXMLDOM.equals(other.configurationEventTypeXMLDOM)) {
            return new ExprValidationException("XML configuration mismatches between types");
        }
        return null;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof BaseXMLEventType)) {
            return false;
        }
        BaseXMLEventType other = (BaseXMLEventType)otherObj;
        return this.configurationEventTypeXMLDOM.equals(other.configurationEventTypeXMLDOM);
    }

    public int hashCode() {
        return this.configurationEventTypeXMLDOM.hashCode();
    }

    @Override
    public EventPropertyWriterSPI getWriter(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        return new EventPropertyDescriptor[0];
    }

    @Override
    public EventBeanCopyMethodForge getCopyMethodForge(String[] properties) {
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        return null;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        return null;
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }
}

