/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMeta;
import com.espertech.esper.common.internal.event.xml.EventTypeXMLXSDHandler;
import com.espertech.esper.common.internal.event.xml.EventTypeXMLXSDHandlerUnsupported;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTypeXMLXSDHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(EventTypeXMLXSDHandlerFactory.class);

    public static EventTypeXMLXSDHandler resolve(ClasspathImportService classpathImportService, ConfigurationCommonEventTypeMeta config, String handlerClass) {
        EventTypeXMLXSDHandler xmlxsdHandler = EventTypeXMLXSDHandlerUnsupported.INSTANCE;
        if (config.isEnableXMLXSD()) {
            try {
                xmlxsdHandler = JavaClassHelper.instantiate(EventTypeXMLXSDHandler.class, handlerClass, classpathImportService.getClassForNameProvider());
            }
            catch (Throwable t) {
                log.warn("XML-XSD provider {} not instantiated, not enabling XML-XSD support: {}", (Object)handlerClass, (Object)t.getMessage());
            }
        }
        return xmlxsdHandler;
    }
}

