/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.FragmentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class FragmentFactoryXPathPredefinedGetter
implements FragmentFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(FragmentFactoryXPathPredefinedGetter.class);
    private static final Logger log = LoggerFactory.getLogger(FragmentFactoryXPathPredefinedGetter.class);
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final EventTypeNameResolver eventTypeResolver;
    private final String eventTypeName;
    private final String propertyName;
    private volatile EventType eventType;

    public FragmentFactoryXPathPredefinedGetter(EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeNameResolver eventTypeResolver, String eventTypeName, String propertyName) {
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.eventTypeResolver = eventTypeResolver;
        this.eventTypeName = eventTypeName;
        this.propertyName = propertyName;
    }

    @Override
    public EventBean getEvent(Node result) {
        if (this.eventType == null) {
            EventType candidateEventType = this.eventTypeResolver.getTypeByName(this.eventTypeName);
            if (candidateEventType == null) {
                log.warn("Event type by name '" + this.eventTypeName + "' was not found for property '" + this.propertyName + "'");
                return null;
            }
            if (!(candidateEventType instanceof BaseXMLEventType)) {
                log.warn("Event type by name '" + this.eventTypeName + "' is not an XML event type for property '" + this.propertyName + "'");
                return null;
            }
            this.eventType = candidateEventType;
        }
        return this.eventBeanTypedEventFactory.adapterForTypedDOM(result, this.eventType);
    }
}

