/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.event.xml.EventTypeXMLXSDHandler;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaElementSimple;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.event.xml.SchemaItemAttribute;
import com.espertech.esper.common.internal.event.xml.SchemaModel;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtil {
    public static final Map<String, EPTypeClass> TYPE_MAP = new HashMap<String, EPTypeClass>();

    public static EPTypeClass toReturnType(SchemaItem item, EventTypeXMLXSDHandler xmlxsdHandler) {
        if (item instanceof SchemaItemAttribute) {
            SchemaItemAttribute att = (SchemaItemAttribute)item;
            return xmlxsdHandler.toReturnType(att.getXsSimpleType(), att.getTypeName(), null);
        }
        if (item instanceof SchemaElementSimple) {
            SchemaElementSimple simple = (SchemaElementSimple)item;
            EPTypeClass returnType = xmlxsdHandler.toReturnType(simple.getXsSimpleType(), simple.getTypeName(), simple.getFractionDigits());
            if (simple.isArray()) {
                returnType = JavaClassHelper.getArrayType(returnType);
            }
            return returnType;
        }
        if (item instanceof SchemaElementComplex) {
            SchemaElementComplex complex = (SchemaElementComplex)item;
            if (complex.getOptionalSimpleType() != null) {
                return xmlxsdHandler.toReturnType(complex.getOptionalSimpleType(), complex.getOptionalSimpleTypeName(), null);
            }
            if (complex.isArray()) {
                return EPTypePremade.NODELIST.getEPType();
            }
            return EPTypePremade.NODE.getEPType();
        }
        throw new PropertyAccessException("Invalid schema return type:" + item);
    }

    public static EPTypeClass toReturnType(QName resultType, EPTypeClass optionalCastToType) {
        if (optionalCastToType != null) {
            return optionalCastToType;
        }
        if (resultType.equals(XPathConstants.NODESET)) {
            return EPTypePremade.NODELIST.getEPType();
        }
        if (resultType.equals(XPathConstants.NODE)) {
            return EPTypePremade.NODE.getEPType();
        }
        if (resultType.equals(XPathConstants.BOOLEAN)) {
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }
        if (resultType.equals(XPathConstants.NUMBER)) {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }
        if (resultType.equals(XPathConstants.STRING)) {
            return EPTypePremade.STRING.getEPType();
        }
        return EPTypePremade.STRING.getEPType();
    }

    public static SchemaElementComplex findRootElement(SchemaModel schema, String namespace, String elementName) {
        if (namespace != null && namespace.length() != 0) {
            for (SchemaElementComplex complexElement : schema.getComponents()) {
                if (!complexElement.getNamespace().equals(namespace) || !complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        } else {
            for (SchemaElementComplex complexElement : schema.getComponents()) {
                if (!complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        }
        if (elementName.startsWith("//")) {
            elementName = elementName.substring(2);
            for (SchemaElementComplex complexElement : schema.getComponents()) {
                SchemaElementComplex match = SchemaUtil.recursiveDeepMatch(complexElement, namespace, elementName);
                if (match == null) continue;
                return match;
            }
        }
        String text = "Could not find root element declaration in schema for element name '" + elementName + "'";
        if (namespace != null) {
            text = text + " in namespace '" + namespace + "'";
        }
        throw new EPException(text);
    }

    private static SchemaElementComplex recursiveDeepMatch(SchemaElementComplex parent, String namespace, String elementName) {
        if (namespace != null && namespace.length() != 0) {
            for (SchemaElementComplex complexElement : parent.getChildren()) {
                if (!complexElement.getNamespace().equals(namespace) || !complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        } else {
            for (SchemaElementComplex complexElement : parent.getChildren()) {
                if (!complexElement.getName().equals(elementName)) continue;
                return complexElement;
            }
        }
        for (SchemaElementComplex complexElement : parent.getChildren()) {
            SchemaElementComplex found = SchemaUtil.recursiveDeepMatch(complexElement, namespace, elementName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static SchemaItem findPropertyMapping(SchemaElementComplex def, String property) {
        for (SchemaItemAttribute attribute : def.getAttributes()) {
            if (!attribute.getName().equals(property)) continue;
            return attribute;
        }
        for (SchemaElementSimple simple : def.getSimpleElements()) {
            if (!simple.getName().equals(property)) continue;
            return simple;
        }
        for (SchemaElementComplex complex : def.getChildren()) {
            if (!complex.getName().equals(property)) continue;
            return complex;
        }
        return null;
    }

    public static String serialize(Node doc) {
        StringWriter writer = new StringWriter();
        try {
            SchemaUtil.serializeNode(doc, "", writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.flush();
        return writer.toString();
    }

    private static void serializeNode(Node node, String indentLevel, StringWriter writer) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                writer.write("<?xml version=\"");
                writer.write(doc.getXmlVersion());
                writer.write("\" encoding=\"UTF-8\" standalone=\"");
                if (doc.getXmlStandalone()) {
                    writer.write("yes");
                } else {
                    writer.write("no");
                }
                writer.write("\"?>\n");
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    SchemaUtil.serializeNode(nodes.item(i), "", writer);
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(indentLevel + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" " + current.getNodeName() + "=\"");
                    SchemaUtil.print(current.getNodeValue(), writer);
                    writer.write("\"");
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write("\n");
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        SchemaUtil.serializeNode(children.item(i), indentLevel, writer);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(indentLevel);
                    }
                }
                writer.write("</" + name + ">\n");
                break;
            }
            case 3: {
                SchemaUtil.print(node.getNodeValue(), writer);
                break;
            }
            case 4: {
                writer.write("CDATA");
                SchemaUtil.print(node.getNodeValue(), writer);
                writer.write("");
                break;
            }
            case 8: {
                writer.write(indentLevel + "<!-- " + node.getNodeValue() + " -->\n");
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>\n");
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                String internalSubset = docType.getInternalSubset();
                writer.write("<!DOCTYPE " + docType.getName());
                if (publicId != null) {
                    writer.write(" PRECONFIGURED \"" + publicId + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + systemId + "\"");
                if (internalSubset != null) {
                    writer.write(" [" + internalSubset + "]");
                }
                writer.write(">\n");
                break;
            }
        }
    }

    private static void print(String s, Writer writer) throws IOException {
        if (s == null) {
            return;
        }
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '\r': {
                    writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    static {
        Object[][] types = new Object[][]{{"nonPositiveInteger", EPTypePremade.INTEGERBOXED.getEPType()}, {"nonNegativeInteger", EPTypePremade.INTEGERBOXED.getEPType()}, {"negativeInteger", EPTypePremade.INTEGERBOXED.getEPType()}, {"positiveInteger", EPTypePremade.INTEGERBOXED.getEPType()}, {"long", EPTypePremade.LONGBOXED.getEPType()}, {"unsignedLong", EPTypePremade.LONGBOXED.getEPType()}, {"int", EPTypePremade.INTEGERBOXED.getEPType()}, {"unsignedInt", EPTypePremade.INTEGERBOXED.getEPType()}, {"decimal", EPTypePremade.DOUBLEBOXED.getEPType()}, {"integer", EPTypePremade.INTEGERBOXED.getEPType()}, {"float", EPTypePremade.FLOATBOXED.getEPType()}, {"double", EPTypePremade.DOUBLEBOXED.getEPType()}, {"string", EPTypePremade.STRING.getEPType()}, {"short", EPTypePremade.SHORTBOXED.getEPType()}, {"unsignedShort", EPTypePremade.SHORTBOXED.getEPType()}, {"byte", EPTypePremade.BYTEBOXED.getEPType()}, {"unsignedByte", EPTypePremade.BYTEBOXED.getEPType()}, {"boolean", EPTypePremade.BOOLEANBOXED.getEPType()}, {"dateTime", EPTypePremade.STRING.getEPType()}, {"date", EPTypePremade.STRING.getEPType()}, {"time", EPTypePremade.STRING.getEPType()}};
        for (int i = 0; i < types.length; ++i) {
            TYPE_MAP.put(types[i][0].toString(), (EPTypeClass)types[i][1]);
        }
    }
}

