/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.XPathPropertyGetter;

public class XPathPropertyGetterCodegenFieldSharable
implements CodegenFieldSharable {
    private final BaseXMLEventType baseXMLEventType;
    private final XPathPropertyGetter xPathPropertyGetter;

    public XPathPropertyGetterCodegenFieldSharable(BaseXMLEventType baseXMLEventType, XPathPropertyGetter xPathPropertyGetter) {
        this.baseXMLEventType = baseXMLEventType;
        this.xPathPropertyGetter = xPathPropertyGetter;
    }

    @Override
    public EPTypeClass type() {
        return XPathPropertyGetter.EPTYPE;
    }

    @Override
    public CodegenExpression initCtorScoped() {
        return CodegenExpressionBuilder.staticMethod(XPathPropertyGetterCodegenFieldSharable.class, "resolveXPathPropertyGetter", EventTypeUtility.resolveTypeCodegen(this.baseXMLEventType, EPStatementInitServices.REF), CodegenExpressionBuilder.constant(this.xPathPropertyGetter.getProperty()));
    }

    public static XPathPropertyGetter resolveXPathPropertyGetter(EventType eventType, String propertyName) {
        if (!(eventType instanceof BaseXMLEventType)) {
            throw new EPException("Failed to obtain xpath property getter, expected an xml event type but received type '" + eventType.getMetadata().getName() + "'");
        }
        BaseXMLEventType type = (BaseXMLEventType)eventType;
        EventPropertyGetter getter = type.getGetter(propertyName);
        if (!(getter instanceof XPathPropertyGetter)) {
            throw new EPException("Failed to obtain xpath property getter for property '" + propertyName + "', expected " + XPathPropertyGetter.class.getSimpleName() + " but received " + getter);
        }
        return (XPathPropertyGetter)getter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPathPropertyGetterCodegenFieldSharable that = (XPathPropertyGetterCodegenFieldSharable)o;
        if (!this.baseXMLEventType.equals(that.baseXMLEventType)) {
            return false;
        }
        return this.xPathPropertyGetter.equals(that.xPathPropertyGetter);
    }

    public int hashCode() {
        int result = this.baseXMLEventType.hashCode();
        result = 31 * result + this.xPathPropertyGetter.hashCode();
        return result;
    }
}

