/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamFilterForEvalDoubleForge;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;

public class FilterForEvalConstantDoubleForge
implements FilterSpecParamFilterForEvalDoubleForge {
    private final double doubleValue;

    public FilterForEvalConstantDoubleForge(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent) {
        return CodegenExpressionBuilder.constant(this.doubleValue);
    }

    @Override
    public Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        return this.doubleValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterForEvalConstantDoubleForge)) {
            return false;
        }
        FilterForEvalConstantDoubleForge other = (FilterForEvalConstantDoubleForge)obj;
        return other.doubleValue == this.doubleValue;
    }

    public int hashCode() {
        long temp = this.doubleValue != 0.0 ? Double.doubleToLongBits(this.doubleValue) : 0L;
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public void valueToString(StringBuilder out) {
        out.append("double-value ").append(this.doubleValue);
    }
}

