/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlan;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPath;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTriplet;
import com.espertech.esper.common.internal.context.util.StatementContextFilterEvalEnv;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.filterspec.FilterAddendumUtil;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.filterspec.PropertyEvaluator;
import java.io.StringWriter;

public final class FilterSpecActivatable {
    public static final EPTypeClass EPTYPE = new EPTypeClass(FilterSpecActivatable.class);
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final FilterSpecPlan plan;
    private final PropertyEvaluator optionalPropertyEvaluator;
    private final int filterCallbackId;

    public FilterSpecActivatable(EventType eventType, String eventTypeName, FilterSpecPlan plan, PropertyEvaluator optionalPropertyEvaluator, int filterCallbackId) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.plan = plan;
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
        if (filterCallbackId == -1) {
            throw new IllegalArgumentException("Filter callback id is unassigned");
        }
        this.filterCallbackId = filterCallbackId;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final FilterSpecPlan getPlan() {
        return this.plan;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluator getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public FilterValueSetParam[][] getValueSet(MatchedEventMap matchedEvents, FilterValueSetParam[][] addendum, ExprEvaluatorContext exprEvaluatorContext, StatementContextFilterEvalEnv filterEvalEnv) {
        FilterValueSetParam[][] valueList = this.plan.evaluateValueSet(matchedEvents, exprEvaluatorContext, filterEvalEnv);
        if (addendum != null) {
            valueList = FilterAddendumUtil.multiplyAddendum(addendum, valueList);
        }
        return valueList;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecActivatable type=" + this.filterForEventType);
        buffer.append(" parameters=" + this.plan.toString());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        for (FilterSpecPlanPath path : this.plan.getPaths()) {
            for (FilterSpecPlanPathTriplet triplet : path.getTriplets()) {
                hashCode ^= 31 * triplet.getParam().hashCode();
            }
        }
        return hashCode;
    }

    public int getFilterCallbackId() {
        return this.filterCallbackId;
    }

    public String getFilterText() {
        StringWriter writer = new StringWriter();
        writer.write(this.getFilterForEventType().getName());
        if (this.getPlan().getPaths() != null && this.getPlan().getPaths().length > 0) {
            writer.write(40);
            String delimiter = "";
            for (FilterSpecPlanPath path : this.getPlan().getPaths()) {
                writer.write(delimiter);
                FilterSpecActivatable.writeFilter(writer, path);
                delimiter = " or ";
            }
            writer.write(41);
        }
        return writer.toString();
    }

    private static void writeFilter(StringWriter writer, FilterSpecPlanPath path) {
        String delimiter = "";
        for (FilterSpecPlanPathTriplet triplet : path.getTriplets()) {
            writer.write(delimiter);
            writer.write(triplet.getParam().getLkupable().getExpression());
            writer.write(triplet.getParam().getFilterOperator().getTextualOp());
            writer.write("...");
            delimiter = ",";
        }
    }
}

