/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.ThreadingProfile;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNode;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.util.StringValue;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FilterSpecParamExprNodeForge
extends FilterSpecParamForge {
    private final ExprNode exprNode;
    private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final StreamTypeService streamTypeService;
    private final boolean hasVariable;
    private final boolean hasFilterStreamSubquery;
    private final boolean hasTableAccess;
    private final StatementCompileTimeServices compileTimeServices;
    private int filterBoolExprId = -1;

    public FilterSpecParamExprNodeForge(ExprFilterSpecLookupableForge lookupable, FilterOperator filterOperator, ExprNode exprNode, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, StreamTypeService streamTypeService, boolean hasSubquery, boolean hasTableAccess, boolean hasVariable, StatementCompileTimeServices compileTimeServices) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        if (filterOperator != FilterOperator.BOOLEAN_EXPRESSION) {
            throw new IllegalArgumentException("Invalid filter operator for filter expression node");
        }
        this.exprNode = exprNode;
        this.taggedEventTypes = taggedEventTypes;
        this.arrayEventTypes = arrayEventTypes;
        this.streamTypeService = streamTypeService;
        this.hasFilterStreamSubquery = hasSubquery;
        this.hasTableAccess = hasTableAccess;
        this.hasVariable = hasVariable;
        this.compileTimeServices = compileTimeServices;
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    public final String toString() {
        return super.toString() + "  exprNode=" + this.exprNode.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamExprNodeForge)) {
            return false;
        }
        FilterSpecParamExprNodeForge other = (FilterSpecParamExprNodeForge)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.exprNode == other.exprNode;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exprNode.hashCode();
        return result;
    }

    public int getFilterBoolExprId() {
        return this.filterBoolExprId;
    }

    public void setFilterBoolExprId(int filterBoolExprId) {
        this.filterBoolExprId = filterBoolExprId;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols) {
        if (this.filterBoolExprId == -1) {
            throw new IllegalStateException("Unassigned filter boolean expression path num");
        }
        CodegenMethod method = parent.makeChild(FilterSpecParamExprNode.EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(ExprFilterSpecLookupable.EPTYPE, "lookupable", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.lookupable.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).declareVar(ExprFilterSpecLookupable.EPTYPE_FILTEROPERATOR, "op", CodegenExpressionBuilder.enumValue(FilterOperator.class, this.filterOperator.name()));
        CodegenExpressionNewAnonymousClass param = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FilterSpecParamExprNode.EPTYPE, Arrays.asList(CodegenExpressionBuilder.ref("lookupable"), CodegenExpressionBuilder.ref("op")));
        CodegenMethod getFilterValue = CodegenMethod.makeParentNode(FilterValueSetParam.EPTYPE, this.getClass(), classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        param.addMethod("getFilterValue", getFilterValue);
        if (this.taggedEventTypes != null && !this.taggedEventTypes.isEmpty() || this.arrayEventTypes != null && !this.arrayEventTypes.isEmpty()) {
            int size = this.taggedEventTypes != null ? this.taggedEventTypes.size() : 0;
            getFilterValue.getBlock().declareVar(EventBean.EPTYPEARRAY, "events", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant((size += this.arrayEventTypes != null ? this.arrayEventTypes.size() : 0) + 1)));
            int count = 1;
            if (this.taggedEventTypes != null) {
                for (String string : this.taggedEventTypes.keySet()) {
                    getFilterValue.getBlock().assignArrayElement("events", CodegenExpressionBuilder.constant(count), CodegenExpressionBuilder.exprDotMethod(FilterSpecParam.REF_MATCHEDEVENTMAP, "getMatchingEventByTag", CodegenExpressionBuilder.constant(string)));
                    ++count;
                }
            }
            if (this.arrayEventTypes != null) {
                for (Map.Entry entry : this.arrayEventTypes.entrySet()) {
                    EventType compositeEventType = (EventType)((Pair)entry.getValue()).getFirst();
                    CodegenExpressionField compositeEventTypeMember = classScope.addFieldUnshared(true, EventType.EPTYPE, EventTypeUtility.resolveTypeCodegen(compositeEventType, EPStatementInitServices.REF));
                    CodegenExpressionField factory = classScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
                    CodegenExpression matchingAsMap = CodegenExpressionBuilder.exprDotMethod(FilterSpecParam.REF_MATCHEDEVENTMAP, "getMatchingEventsAsMap", new CodegenExpression[0]);
                    CodegenExpression mapBean = CodegenExpressionBuilder.exprDotMethod(factory, "adapterForTypedMap", matchingAsMap, compositeEventTypeMember);
                    getFilterValue.getBlock().assignArrayElement("events", CodegenExpressionBuilder.constant(count), mapBean);
                    ++count;
                }
            }
        } else {
            getFilterValue.getBlock().declareVar(EventBean.EPTYPEARRAY, "events", CodegenExpressionBuilder.constantNull());
        }
        getFilterValue.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("filterBooleanExpressionFactory"), "make", CodegenExpressionBuilder.ref("this"), CodegenExpressionBuilder.ref("events"), ExprForgeCodegenNames.REF_EXPREVALCONTEXT, CodegenExpressionBuilder.exprDotMethod(ExprForgeCodegenNames.REF_EXPREVALCONTEXT, "getAgentInstanceId", new CodegenExpression[0]), FilterSpecParam.REF_STMTCTXFILTEREVALENV)).methodReturn(FilterValueSetParamImpl.codegenNew(CodegenExpressionBuilder.ref("value")));
        CodegenExpressionNewAnonymousClass evaluator = ExprNodeUtilityCodegen.codegenEvaluatorNoCoerce(this.exprNode.getForge(), method, this.getClass(), classScope);
        method.getBlock().declareVar(FilterSpecParamExprNode.EPTYPE, "node", (CodegenExpression)param).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setExprText", CodegenExpressionBuilder.constant(StringValue.stringDelimitedTo60Char(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.exprNode)))).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setExprNode", evaluator).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setHasVariable", CodegenExpressionBuilder.constant(this.hasVariable)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setHasFilterStreamSubquery", CodegenExpressionBuilder.constant(this.hasFilterStreamSubquery)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setFilterBoolExprId", CodegenExpressionBuilder.constant(this.filterBoolExprId)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setHasTableAccess", CodegenExpressionBuilder.constant(this.hasTableAccess)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setFilterBooleanExpressionFactory", CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getFilterBooleanExpressionFactory", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setUseLargeThreadingProfile", CodegenExpressionBuilder.constant(this.compileTimeServices.getConfiguration().getCommon().getExecution().getThreadingProfile() == ThreadingProfile.LARGE));
        EventType[] providedTypes = this.providedTypesStartingStreamOne();
        if (providedTypes != null) {
            method.getBlock().declareVar(EventType.EPTYPEARRAY, "providedTypes", CodegenExpressionBuilder.newArrayByLength(EventType.EPTYPE, CodegenExpressionBuilder.constant(providedTypes.length)));
            for (int i = 1; i < providedTypes.length; ++i) {
                method.getBlock().assignArrayElement("providedTypes", CodegenExpressionBuilder.constant(i), EventTypeUtility.resolveTypeCodegen(providedTypes[i], EPStatementInitServices.REF));
            }
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setEventTypesProvidedBy", CodegenExpressionBuilder.ref("providedTypes"));
        }
        method.getBlock().expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getFilterSharedBoolExprRegistery", new CodegenExpression[0]).add("registerBoolExpr", CodegenExpressionBuilder.ref("node")));
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("node"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public EventType[] providedTypesStartingStreamOne() {
        if (this.taggedEventTypes != null && !this.taggedEventTypes.isEmpty() || this.arrayEventTypes != null && !this.arrayEventTypes.isEmpty()) {
            int size = this.taggedEventTypes != null ? this.taggedEventTypes.size() : 0;
            EventType[] providedTypes = new EventType[(size += this.arrayEventTypes != null ? this.arrayEventTypes.size() : 0) + 1];
            for (int i = 1; i < this.streamTypeService.getStreamNames().length; ++i) {
                String tag = this.streamTypeService.getStreamNames()[i];
                EventType eventType = this.findMayNull(tag, this.taggedEventTypes);
                if (eventType == null) {
                    eventType = this.findMayNull(tag, this.arrayEventTypes);
                }
                if (eventType == null) {
                    throw new IllegalStateException("Failed to find event type for tag '" + tag + "'");
                }
                providedTypes[i] = eventType;
            }
            return providedTypes;
        }
        return null;
    }

    @Override
    public void valueExprToString(StringBuilder out, int i) {
        out.append("expression '").append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.exprNode)).append("'");
    }

    public static String valueExprToString(String expression) {
        return "expression '" + expression + "'";
    }

    private EventType findMayNull(String tag, LinkedHashMap<String, Pair<EventType, String>> tags) {
        if (tags == null || !tags.containsKey(tag)) {
            return null;
        }
        return tags.get(tag).getFirst();
    }
}

