/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.HashableMultiKey;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiler;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInAdder;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceRuntime;
import com.espertech.esper.common.internal.util.Indent;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class FilterSpecParamInForge
extends FilterSpecParamForge {
    private final List<FilterSpecParamInValueForge> listOfValues;
    private Object[] inListConstantsOnly;
    private boolean hasCollMapOrArray;
    private FilterSpecParamInAdder[] adders;

    public FilterSpecParamInForge(ExprFilterSpecLookupableForge lookupable, FilterOperator filterOperator, List<FilterSpecParamInValueForge> listofValues) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.listOfValues = listofValues;
        for (FilterSpecParamInValueForge value : listofValues) {
            EPType returnType = value.getReturnType();
            if (!JavaClassHelper.isCollectionMapOrArray(returnType)) continue;
            this.hasCollMapOrArray = true;
            break;
        }
        if (this.hasCollMapOrArray) {
            this.adders = new FilterSpecParamInAdder[listofValues.size()];
            for (int i = 0; i < listofValues.size(); ++i) {
                EPType returnType = listofValues.get(i).getReturnType();
                this.adders[i] = returnType == null || returnType == EPTypeNull.INSTANCE ? InValueAdderPlain.INSTANCE : (((EPTypeClass)returnType).getType().isArray() ? InValueAdderArray.INSTANCE : (JavaClassHelper.isImplementsInterface(returnType, Map.class) ? InValueAdderMap.INSTANCE : (JavaClassHelper.isImplementsInterface(returnType, Collection.class) ? InValueAdderColl.INSTANCE : InValueAdderPlain.INSTANCE)));
            }
        }
        boolean isAllConstants = true;
        for (FilterSpecParamInValueForge value : listofValues) {
            if (value.isConstant()) continue;
            isAllConstants = false;
            break;
        }
        if (isAllConstants) {
            this.inListConstantsOnly = this.getFilterValues(null, null);
        }
        if (filterOperator != FilterOperator.IN_LIST_OF_VALUES && filterOperator != FilterOperator.NOT_IN_LIST_OF_VALUES) {
            throw new IllegalArgumentException("Illegal filter operator " + filterOperator + " supplied to in-values filter parameter");
        }
    }

    public final Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext, ClasspathImportServiceRuntime classpathImportService, Annotation[] annotations) {
        if (this.inListConstantsOnly != null) {
            return this.inListConstantsOnly;
        }
        return this.getFilterValues(matchedEvents, exprEvaluatorContext);
    }

    public final String toString() {
        return super.toString() + "  in=(listOfValues=" + this.listOfValues.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamInForge)) {
            return false;
        }
        FilterSpecParamInForge other = (FilterSpecParamInForge)obj;
        if (!super.equals(other)) {
            return false;
        }
        if (this.listOfValues.size() != other.listOfValues.size()) {
            return false;
        }
        return Arrays.deepEquals(this.listOfValues.toArray(), other.listOfValues.toArray());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.listOfValues != null ? this.listOfValues.hashCode() : 0);
        return result;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols) {
        CodegenExpression filterForValue;
        CodegenMethod method = parent.makeChild(FilterSpecParam.EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(ExprFilterSpecLookupable.EPTYPE, "lookupable", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.lookupable.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).declareVar(ExprFilterSpecLookupable.EPTYPE_FILTEROPERATOR, "op", CodegenExpressionBuilder.enumValue(FilterOperator.class, this.filterOperator.name()));
        CodegenExpressionNewAnonymousClass param = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FilterSpecParam.EPTYPE, Arrays.asList(CodegenExpressionBuilder.ref("lookupable"), CodegenExpressionBuilder.ref("op")));
        CodegenMethod getFilterValue = CodegenMethod.makeParentNode(FilterValueSetParam.EPTYPE, this.getClass(), classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        param.addMethod("getFilterValue", getFilterValue);
        if (this.inListConstantsOnly != null) {
            filterForValue = CodegenExpressionBuilder.newInstance(HashableMultiKey.EPTYPE, CodegenExpressionBuilder.constant(this.inListConstantsOnly));
        } else if (!this.hasCollMapOrArray) {
            getFilterValue.getBlock().declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "values", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(this.listOfValues.size())));
            for (int i = 0; i < this.listOfValues.size(); ++i) {
                FilterSpecParamInValueForge forge = this.listOfValues.get(i);
                getFilterValue.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("values"), CodegenExpressionBuilder.constant(i), forge.makeCodegen(classScope, method));
            }
            filterForValue = CodegenExpressionBuilder.newInstance(HashableMultiKey.EPTYPE, CodegenExpressionBuilder.ref("values"));
        } else {
            getFilterValue.getBlock().declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "values", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.constant(this.listOfValues.size())));
            for (int i = 0; i < this.listOfValues.size(); ++i) {
                String valueName = "value" + i;
                String adderName = "adder" + i;
                getFilterValue.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), valueName, this.listOfValues.get(i).makeCodegen(classScope, parent)).ifRefNotNull(valueName).declareVar(this.adders[i].getEPType(), adderName, CodegenExpressionBuilder.enumValue(this.adders[i].getClass(), "INSTANCE")).exprDotMethod(CodegenExpressionBuilder.ref(adderName), "add", CodegenExpressionBuilder.ref("values"), CodegenExpressionBuilder.ref(valueName)).blockEnd();
            }
            filterForValue = CodegenExpressionBuilder.newInstance(HashableMultiKey.EPTYPE, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("values"), "toArray", new CodegenExpression[0]));
        }
        getFilterValue.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "val", filterForValue).methodReturn(FilterValueSetParamImpl.codegenNew(CodegenExpressionBuilder.ref("val")));
        method.getBlock().methodReturn(param);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private Object[] getFilterValues(MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (!this.hasCollMapOrArray) {
            Object[] constants = new Object[this.listOfValues.size()];
            int count = 0;
            for (FilterSpecParamInValueForge valuePlaceholder : this.listOfValues) {
                constants[count++] = valuePlaceholder.getFilterValue(matchedEvents, exprEvaluatorContext);
            }
            return constants;
        }
        ArrayDeque<Object> constants = new ArrayDeque<Object>(this.listOfValues.size());
        int count = 0;
        for (FilterSpecParamInValueForge valuePlaceholder : this.listOfValues) {
            Object value = valuePlaceholder.getFilterValue(matchedEvents, exprEvaluatorContext);
            if (value != null) {
                this.adders[count].add(constants, value);
            }
            ++count;
        }
        return constants.toArray();
    }

    @Override
    public void valueExprToString(StringBuilder out, int indent) {
        if (this.inListConstantsOnly != null) {
            out.append("constant values, ").append(this.inListConstantsOnly.length).append(" entries").append(FilterSpecCompiler.NEWLINE);
            for (int i = 0; i < this.inListConstantsOnly.length; ++i) {
                out.append(Indent.indent(indent)).append("value #").append(i).append(": ");
                FilterSpecParamConstantForge.valueExprToString(out, this.inListConstantsOnly[i]);
                out.append(FilterSpecCompiler.NEWLINE);
            }
        }
        out.append("non-constant values, ").append(this.listOfValues.size()).append(" entries").append(FilterSpecCompiler.NEWLINE);
        int valueIndex = 0;
        for (FilterSpecParamInValueForge forge : this.listOfValues) {
            out.append(Indent.indent(indent)).append("value #").append(valueIndex).append(": ");
            forge.valueToString(out);
            out.append(FilterSpecCompiler.NEWLINE);
            ++valueIndex;
        }
    }

    public static class InValueAdderPlain
    implements FilterSpecParamInAdder {
        public static final EPTypeClass EPTYPE = new EPTypeClass(InValueAdderPlain.class);
        public static final InValueAdderPlain INSTANCE = new InValueAdderPlain();

        private InValueAdderPlain() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            constants.add(value);
        }

        @Override
        public void valueToString(StringBuilder out) {
            out.append("collection");
        }

        @Override
        public EPTypeClass getEPType() {
            return EPTYPE;
        }
    }

    public static class InValueAdderArray
    implements FilterSpecParamInAdder {
        public static final EPTypeClass EPTYPE = new EPTypeClass(InValueAdderArray.class);
        public static final InValueAdderArray INSTANCE = new InValueAdderArray();

        @Override
        public EPTypeClass getEPType() {
            return EPTYPE;
        }

        private InValueAdderArray() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                constants.add(Array.get(value, i));
            }
        }

        @Override
        public void valueToString(StringBuilder out) {
            out.append("collection");
        }
    }

    public static class InValueAdderMap
    implements FilterSpecParamInAdder {
        public static final EPTypeClass EPTYPE = new EPTypeClass(InValueAdderMap.class);
        public static final InValueAdderMap INSTANCE = new InValueAdderMap();

        private InValueAdderMap() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            Map map = (Map)value;
            constants.addAll(map.keySet());
        }

        @Override
        public void valueToString(StringBuilder out) {
            out.append("map keys");
        }

        @Override
        public EPTypeClass getEPType() {
            return EPTYPE;
        }
    }

    public static class InValueAdderColl
    implements FilterSpecParamInAdder {
        public static final EPTypeClass EPTYPE = new EPTypeClass(InValueAdderColl.class);
        public static final InValueAdderColl INSTANCE = new InValueAdderColl();

        private InValueAdderColl() {
        }

        @Override
        public void add(Collection<Object> constants, Object value) {
            Collection coll = (Collection)value;
            constants.addAll(coll);
        }

        @Override
        public void valueToString(StringBuilder out) {
            out.append("collection");
        }

        @Override
        public EPTypeClass getEPType() {
            return EPTYPE;
        }
    }
}

