/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.filterspec.DoubleRange;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamFilterForEvalForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.filterspec.StringRange;
import java.util.Arrays;

public final class FilterSpecParamRangeForge
extends FilterSpecParamForge {
    private final FilterSpecParamFilterForEvalForge min;
    private final FilterSpecParamFilterForEvalForge max;

    public FilterSpecParamRangeForge(ExprFilterSpecLookupableForge lookupable, FilterOperator filterOperator, FilterSpecParamFilterForEvalForge min, FilterSpecParamFilterForEvalForge max) throws IllegalArgumentException {
        super(lookupable, filterOperator);
        this.min = min;
        this.max = max;
        if (!filterOperator.isRangeOperator() && !filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + filterOperator + " supplied to range filter parameter");
        }
    }

    public final String toString() {
        return super.toString() + "  range=(min=" + this.min.toString() + ",max=" + this.max.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamRangeForge)) {
            return false;
        }
        FilterSpecParamRangeForge other = (FilterSpecParamRangeForge)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.min.equals(other.min) && this.max.equals(other.max);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        return result;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols) {
        CodegenMethod method = parent.makeChild(FilterSpecParam.EPTYPE, FilterSpecParamConstantForge.class, (CodegenScope)classScope);
        method.getBlock().declareVar(ExprFilterSpecLookupable.EPTYPE, "lookupable", (CodegenExpression)CodegenExpressionBuilder.localMethod(this.lookupable.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).declareVar(ExprFilterSpecLookupable.EPTYPE_FILTEROPERATOR, "op", CodegenExpressionBuilder.enumValue(FilterOperator.class, this.filterOperator.name()));
        CodegenExpressionNewAnonymousClass param = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), FilterSpecParam.EPTYPE, Arrays.asList(CodegenExpressionBuilder.ref("lookupable"), CodegenExpressionBuilder.ref("op")));
        CodegenMethod getFilterValue = CodegenMethod.makeParentNode(FilterValueSetParam.EPTYPE, this.getClass(), classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        param.addMethod("getFilterValue", getFilterValue);
        EPTypeClass returnType = DoubleRange.EPTYPE;
        EPTypeClass castType = EPTypePremade.DOUBLEBOXED.getEPType();
        if (this.lookupable.getReturnType().getType() == String.class) {
            castType = EPTypePremade.STRING.getEPType();
            returnType = StringRange.EPTYPE;
        }
        getFilterValue.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "min", this.min.makeCodegen(classScope, method)).declareVar(EPTypePremade.OBJECT.getEPType(), "max", this.max.makeCodegen(classScope, method)).declareVar(EPTypePremade.OBJECT.getEPType(), "value", CodegenExpressionBuilder.newInstance(returnType, CodegenExpressionBuilder.cast(castType, (CodegenExpression)CodegenExpressionBuilder.ref("min")), CodegenExpressionBuilder.cast(castType, (CodegenExpression)CodegenExpressionBuilder.ref("max")))).methodReturn(FilterValueSetParamImpl.codegenNew(CodegenExpressionBuilder.ref("value")));
        method.getBlock().methodReturn(param);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public void valueExprToString(StringBuilder out, int i) {
        out.append("lower ");
        this.min.valueToString(out);
        out.append(" upper ");
        this.max.valueToString(out);
    }
}

