/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.stmtmetrics;

import com.espertech.esper.common.client.metric.EPMetricsStatement;
import com.espertech.esper.common.client.metric.StatementMetric;
import com.espertech.esper.common.internal.util.DeploymentIdNamePair;
import com.espertech.esper.common.internal.util.ManagedReadWriteLock;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class StatementMetricArray {
    private final String runtimeURI;
    private final ManagedReadWriteLock rwLock;
    private final String name;
    private final boolean isReportInactive;
    private DeploymentIdNamePair[] statementNames;
    private int currentLastElement;
    private volatile StatementMetric[] metrics;
    private Set<DeploymentIdNamePair> removedStatementNames;

    public StatementMetricArray(String runtimeURI, String name, int initialSize, boolean isReportInactive) {
        this.runtimeURI = runtimeURI;
        this.isReportInactive = isReportInactive;
        this.name = name;
        this.metrics = new StatementMetric[initialSize];
        this.statementNames = new DeploymentIdNamePair[initialSize];
        this.currentLastElement = -1;
        this.rwLock = new ManagedReadWriteLock("StatementMetricArray-" + name, true);
        this.removedStatementNames = new HashSet<DeploymentIdNamePair>();
    }

    public void removeStatement(DeploymentIdNamePair statement) {
        this.rwLock.acquireWriteLock();
        try {
            this.removedStatementNames.add(statement);
            if (this.removedStatementNames.size() > 1000) {
                for (int i = 0; i <= this.currentLastElement; ++i) {
                    if (!this.removedStatementNames.contains(this.statementNames[i])) continue;
                    this.statementNames[i] = null;
                }
                this.removedStatementNames.clear();
            }
        }
        finally {
            this.rwLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addStatementGetIndex(DeploymentIdNamePair statement) {
        this.rwLock.acquireWriteLock();
        try {
            if (this.currentLastElement + 1 < this.metrics.length) {
                ++this.currentLastElement;
                this.statementNames[this.currentLastElement] = statement;
                int n = this.currentLastElement;
                return n;
            }
            for (int i = 0; i < this.statementNames.length; ++i) {
                if (this.statementNames[i] != null) continue;
                this.statementNames[i] = statement;
                if (i + 1 > this.currentLastElement) {
                    this.currentLastElement = i;
                }
                int n = i;
                return n;
            }
            int newSize = (int)((double)this.metrics.length * 1.5);
            DeploymentIdNamePair[] newStatementNames = new DeploymentIdNamePair[newSize];
            StatementMetric[] newMetrics = new StatementMetric[newSize];
            System.arraycopy(this.statementNames, 0, newStatementNames, 0, this.statementNames.length);
            System.arraycopy(this.metrics, 0, newMetrics, 0, this.metrics.length);
            this.statementNames = newStatementNames;
            this.metrics = newMetrics;
            ++this.currentLastElement;
            this.statementNames[this.currentLastElement] = statement;
            int n = this.currentLastElement;
            return n;
        }
        finally {
            this.rwLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementMetric[] flushMetrics() {
        this.rwLock.acquireWriteLock();
        try {
            boolean isEmpty = this.currentLastElement == -1;
            this.housekeeping();
            if (isEmpty) {
                StatementMetric[] statementMetricArray = null;
                return statementMetricArray;
            }
            StatementMetric[] newMetrics = new StatementMetric[this.metrics.length];
            StatementMetric[] oldMetrics = this.metrics;
            this.metrics = newMetrics;
            StatementMetric[] statementMetricArray = oldMetrics;
            return statementMetricArray;
        }
        finally {
            this.rwLock.releaseWriteLock();
        }
    }

    public ManagedReadWriteLock getRwLock() {
        return this.rwLock;
    }

    public StatementMetric getAddMetric(int index) {
        StatementMetric metric = this.metrics[index];
        if (metric == null) {
            this.metrics[index] = metric = new StatementMetric(this.runtimeURI, this.statementNames[index].getDeploymentId(), this.statementNames[index].getName());
        }
        return metric;
    }

    public int sizeLastElement() {
        return this.currentLastElement + 1;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(Consumer<EPMetricsStatement> consumer) {
        this.rwLock.acquireReadLock();
        try {
            this.housekeeping();
            for (StatementMetric metric : this.metrics) {
                if (metric == null) continue;
                consumer.accept(new EPMetricsStatement(metric));
            }
        }
        finally {
            this.rwLock.releaseReadLock();
        }
    }

    private void housekeeping() {
        int i;
        if (this.isReportInactive) {
            for (i = 0; i <= this.currentLastElement; ++i) {
                if (this.statementNames[i] == null) continue;
                this.metrics[i] = new StatementMetric(this.runtimeURI, this.statementNames[i].getDeploymentId(), this.statementNames[i].getName());
            }
        }
        if (this.currentLastElement > -1 && !this.removedStatementNames.isEmpty()) {
            for (i = 0; i <= this.currentLastElement; ++i) {
                if (!this.removedStatementNames.contains(this.statementNames[i])) continue;
                this.statementNames[i] = null;
            }
        }
        while (this.currentLastElement != -1 && this.statementNames[this.currentLastElement] == null) {
            --this.currentLastElement;
        }
    }

    public boolean isReportInactive() {
        return this.isReportInactive;
    }
}

