/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.eventtype;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.json.compiletime.JsonUnderlyingField;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.serde.DIOJsonObjectSerde;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.path.EventTypeResolver;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StmtClassForgeableBaseNestableEventTypeSerde
implements StmtClassForgeable {
    private static final String OBJECT_NAME = "obj";
    private static final String OUTPUT_NAME = "output";
    private static final String INPUT_NAME = "input";
    private static final String UNITKEY_NAME = "unitKey";
    private static final String WRITER_NAME = "writer";
    private final String className;
    private final CodegenPackageScope packageScope;
    private final BaseNestableEventType eventType;
    private final DataInputOutputSerdeForge[] forges;

    public StmtClassForgeableBaseNestableEventTypeSerde(String className, CodegenPackageScope packageScope, BaseNestableEventType eventType, DataInputOutputSerdeForge[] forges) {
        this.className = className;
        this.packageScope = packageScope;
        this.eventType = eventType;
        this.forges = forges;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod writeMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), StmtClassForgeableBaseNestableEventTypeSerde.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.OBJECT.getEPType(), OBJECT_NAME).addParam(EPTypePremade.DATAOUTPUT.getEPType(), OUTPUT_NAME).addParam(EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), UNITKEY_NAME).addParam(EventBeanCollatedWriter.EPTYPE, WRITER_NAME).addThrown(EPTypePremade.IOEXCEPTION.getEPType());
        this.makeWriteMethod(writeMethod);
        CodegenStackGenerator.recursiveBuildStack(writeMethod, "write", methods);
        CodegenMethod readMethod = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), StmtClassForgeableBaseNestableEventTypeSerde.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.DATAINPUT.getEPType(), INPUT_NAME).addParam(EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), UNITKEY_NAME).addThrown(EPTypePremade.IOEXCEPTION.getEPType());
        this.makeReadMethod(readMethod);
        CodegenStackGenerator.recursiveBuildStack(readMethod, "read", methods);
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>();
        for (int i = 0; i < this.forges.length; ++i) {
            members.add(new CodegenTypedParam(this.forges[i].forgeClassName(), "s" + i));
        }
        List<CodegenTypedParam> ctorParams = Collections.singletonList(new CodegenTypedParam(EventTypeResolver.EPTYPE, "resolver", false));
        CodegenCtor providerCtor = new CodegenCtor(this.getClass(), includeDebugSymbols, ctorParams);
        for (int i = 0; i < this.forges.length; ++i) {
            providerCtor.getBlock().assignRef("s" + i, this.forges[i].codegen(providerCtor, classScope, CodegenExpressionBuilder.ref("resolver")));
        }
        return new CodegenClass(CodegenClassType.EVENTSERDE, DataInputOutputSerde.EPTYPE, this.className, classScope, members, providerCtor, methods, Collections.emptyList());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.MULTIKEY;
    }

    private void makeWriteMethod(CodegenMethod writeMethod) {
        JsonEventType jsonEventType;
        String[] propertyNames = this.eventType.getPropertyNames();
        if (this.eventType instanceof MapEventType) {
            writeMethod.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "map", CodegenExpressionBuilder.cast(EPTypePremade.MAP.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref(OBJECT_NAME)));
        } else if (this.eventType instanceof ObjectArrayEventType) {
            writeMethod.getBlock().declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "oa", CodegenExpressionBuilder.cast(EPTypePremade.OBJECTARRAY.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref(OBJECT_NAME)));
        } else if (this.eventType instanceof JsonEventType) {
            JsonEventType jsonEventType2 = (JsonEventType)this.eventType;
            writeMethod.getBlock().declareVar(jsonEventType2.getUnderlyingEPType(), "json", CodegenExpressionBuilder.cast(jsonEventType2.getUnderlyingEPType(), (CodegenExpression)CodegenExpressionBuilder.ref(OBJECT_NAME)));
        } else {
            throw new IllegalStateException("Unrecognized event type " + this.eventType);
        }
        for (int i = 0; i < this.forges.length; ++i) {
            CodegenExpression get;
            CodegenExpressionRef serde = CodegenExpressionBuilder.ref("s" + i);
            if (this.eventType instanceof MapEventType) {
                get = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("map"), "get", CodegenExpressionBuilder.constant(propertyNames[i]));
            } else if (this.eventType instanceof ObjectArrayEventType) {
                get = CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("oa"), CodegenExpressionBuilder.constant(i));
            } else {
                JsonEventType jsonEventType3 = (JsonEventType)this.eventType;
                String property = this.eventType.getPropertyNames()[i];
                JsonUnderlyingField field = jsonEventType3.getDetail().getFieldDescriptors().get(property);
                if (field == null) {
                    throw new IllegalStateException("Unrecognized json event property " + property);
                }
                get = CodegenExpressionBuilder.ref("json." + field.getFieldName());
            }
            writeMethod.getBlock().exprDotMethod(serde, "write", get, CodegenExpressionBuilder.ref(OUTPUT_NAME), CodegenExpressionBuilder.ref(UNITKEY_NAME), CodegenExpressionBuilder.ref(WRITER_NAME));
        }
        if (this.eventType instanceof JsonEventType && (jsonEventType = (JsonEventType)this.eventType).getDetail().isDynamic()) {
            CodegenExpressionRef get = CodegenExpressionBuilder.ref("json.__dyn");
            writeMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.publicConstValue(DIOJsonObjectSerde.class, "INSTANCE"), "write", get, CodegenExpressionBuilder.ref(OUTPUT_NAME), CodegenExpressionBuilder.ref(UNITKEY_NAME), CodegenExpressionBuilder.ref(WRITER_NAME));
        }
    }

    private void makeReadMethod(CodegenMethod readMethod) {
        JsonEventType jsonEventType;
        CodegenExpressionRef underlyingRef;
        String[] propertyNames = this.eventType.getPropertyNames();
        if (this.eventType instanceof MapEventType) {
            readMethod.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "map", CodegenExpressionBuilder.newInstance(EPTypePremade.HASHMAP.getEPType(), CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(this.forges.length))));
            underlyingRef = CodegenExpressionBuilder.ref("map");
        } else if (this.eventType instanceof ObjectArrayEventType) {
            readMethod.getBlock().declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "oa", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(this.forges.length)));
            underlyingRef = CodegenExpressionBuilder.ref("oa");
        } else if (this.eventType instanceof JsonEventType) {
            JsonEventType jsonEventType2 = (JsonEventType)this.eventType;
            readMethod.getBlock().declareVar(jsonEventType2.getUnderlyingEPType(), "json", CodegenExpressionBuilder.newInstance(jsonEventType2.getUnderlyingEPType(), new CodegenExpression[0]));
            underlyingRef = CodegenExpressionBuilder.ref("json");
        } else {
            throw new IllegalStateException("Unrecognized event type " + this.eventType);
        }
        for (int i = 0; i < this.forges.length; ++i) {
            CodegenExpressionRef serde = CodegenExpressionBuilder.ref("s" + i);
            CodegenExpression read = CodegenExpressionBuilder.exprDotMethod(serde, "read", CodegenExpressionBuilder.ref(INPUT_NAME), CodegenExpressionBuilder.ref(UNITKEY_NAME));
            if (this.eventType instanceof MapEventType) {
                readMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("map"), "put", CodegenExpressionBuilder.constant(propertyNames[i]), read);
                continue;
            }
            if (this.eventType instanceof ObjectArrayEventType) {
                readMethod.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("oa"), CodegenExpressionBuilder.constant(i), read);
                continue;
            }
            JsonEventType jsonEventType3 = (JsonEventType)this.eventType;
            String property = this.eventType.getPropertyNames()[i];
            JsonUnderlyingField field = jsonEventType3.getDetail().getFieldDescriptors().get(property);
            if (field == null) {
                throw new IllegalStateException("Unrecognized json event property " + property);
            }
            readMethod.getBlock().assignRef(CodegenExpressionBuilder.ref("json." + field.getFieldName()), CodegenExpressionBuilder.cast(field.getPropertyType(), read));
        }
        if (this.eventType instanceof JsonEventType && (jsonEventType = (JsonEventType)this.eventType).getDetail().isDynamic()) {
            CodegenExpression read = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.publicConstValue(DIOJsonObjectSerde.class, "INSTANCE"), "read", CodegenExpressionBuilder.ref(INPUT_NAME), CodegenExpressionBuilder.ref(UNITKEY_NAME));
            readMethod.getBlock().assignRef(CodegenExpressionBuilder.ref("json.__dyn"), read);
        }
        readMethod.getBlock().methodReturn(underlyingRef);
    }
}

